<?php

namespace Hilco\Providers;

use Illuminate\Support\ServiceProvider;

class HilcoB2BSharedProvider extends ServiceProvider {
    public function register() {
        $this->mergeConfigFrom(__DIR__ . '/../../config/layoutcomponents.php', 'layoutcomponents');
        $this->mergeConfigFrom(__DIR__ . '/../../config/hilco.php', 'hilco');
    }

    public function boot() {
        $this->publishes([
            __DIR__ . '/../../config/layoutcomponents.php' => config_path('layoutcomponents.php')
        ], 'hilco-shared');

        $this->publishes([
            __DIR__ . '/../../config/hilco.php' => config_path('hilco.php')
        ], 'hilco');

        $this->loadViewsFrom(__DIR__ . '/../../resources/views', 'hilco');
    }
}