<?php

namespace Hilco\Models;

use Blade;
use Storage;

trait HasLandingPage {
    public function webAttributeFilters() {
        return $this->morphMany(WebAttributeFilter::class, 'filterable');
    }

    public function getFiltersAttribute() {
        $filters = $this->webAttributeFilters()->has('webAttribute')->with('webAttribute')->get();
        $attributes = [];
        foreach ($filters as $filter) {
            $attributes[$filter->webAttribute->id]['id'] = $filter->webAttribute->id;
            $attributes[$filter->webAttribute->id]['attribute_name'] = $filter->webAttribute->attribute_name;
            $attributes[$filter->webAttribute->id]['webAttributeFilters'][$filter->id]['id'] = $filter->id;
            $attributes[$filter->webAttribute->id]['webAttributeFilters'][$filter->id]['display_as'] = $filter->display_as;
        }
        foreach ($attributes as $id => $attribute) {
            $attributes[$id]['webAttributeFilters'] = array_sort($attribute['webAttributeFilters'], function ($item) {
                return $item['display_as'];
            });
        }
        array_sort($attributes, function ($item) {
            return $item['attribute_name'];
        });
        return $attributes;
    }

}