<?php

namespace Hilco\Models;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Collection;


/**
 * Hilco\Models\SalesRep
 *
 * @property integer $id
 * @property string $username
 * @property string $password
 * @property string $role
 * @property string $language_locale
 * @property string $timezone
 * @property string $firstname
 * @property string $lastname
 * @property string $pointman_name
 * @property string $company
 * @property string $division
 * @property string $department
 * @property string $title
 * @property string $email
 * @property string $phone
 * @property string $date_created
 * @property string $date_modified
 * @property string $date_uploaded
 * @property string $deleted_at
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\SalesRep whereId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\SalesRep whereUsername($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\SalesRep wherePassword($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\SalesRep whereRole($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\SalesRep whereLanguageLocale($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\SalesRep whereTimezone($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\SalesRep whereFirstname($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\SalesRep whereLastname($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\SalesRep wherePointmanName($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\SalesRep whereCompany($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\SalesRep whereDivision($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\SalesRep whereDepartment($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\SalesRep whereTitle($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\SalesRep whereEmail($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\SalesRep wherePhone($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\SalesRep whereDateCreated($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\SalesRep whereDateModified($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\SalesRep whereDateUploaded($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\SalesRep whereDeletedAt($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\SalesRep customSelectForPermissions($value, $value)
 * @mixin \Eloquent
 */

class SalesRep extends WebModel
{
    /**
     * @var string
     */
    protected $table = "SalesReps";
    /**
     * @var array
     */
    protected $fillable = ['username', 'password', 'role', 'timezone', 'commit_sequence'];


    use HasCommitSequence;

    /**
     * @return mixed
     */
    public function ImportUser()
	{
		return Import_User::where("username", "=", $this->getAttribute("username"))->first();
	}

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function calls() {
	    return $this->hasMany(Call::class, 'salesrep_id', 'id');
    }

    /**
     * @return mixed
     */
    public function callsCount() {
	    return $this->hasMany(Call::class, 'salesrep_id', 'id')
            ->selectRaw('COUNT(Calls.id) as aggregate')
            ->groupBy('salesrep_id')
        ;
    }

    /**
     * @return int
     */
    public function getCallsCountAttribute() {
	    if (!array_key_exists('callsCount', $this->relations)) $this->load('callsCount');
	    $related = $this->getRelation('callsCount')->first();
	    return ($related) ? $related->aggregate : 0;
    }

    /**
     * @param $query
     * @param $approvalReasonId
     * @return mixed
     */
    public function scopeCustomSelectForPermissions ($query, $salesRepId, $approvalReasonId) {
	    return $query->join('ApprovalReasons', function($join) use ($approvalReasonId) {
            return $join
                ->on('ApprovalReasons.id', '=', 'ApprovalReasons.id')
                ->where('ApprovalReasons.id', '=', $approvalReasonId)
                ->where('ApprovalReasons.deleted_at', '=', '0000-00-00 00:00:00');
        })->join('SalesRep_Division', function ($join) {
            return $join
                ->on('SalesReps.id', '=', 'SalesRep_Division.salesrep_id')
                ->whereNotNull('SalesRep_Division.division_id')
                ->whereNotIn('SalesRep_Division.division_id', Division::legacyDivisionIDs()->toArray())
                ->where('SalesRep_Division.deleted_at', '=', '0000-00-00 00:00:00');
        })->join('SalesRep_Title', function ($join) {
            return $join
                ->on('SalesReps.id', '=', 'SalesRep_Title.salesrep_id')
                ->where('SalesRep_Title.deleted_at', '=', '0000-00-00 00:00:00');
        })->join('SalesRepTitles', function ($join) {
            return $join
                ->on('SalesRep_Title.salesreptitle_id', '=', 'SalesRepTitles.id')
                ->where('SalesRepTitles.deleted_at', '=', '0000-00-00 00:00:00');
        })->whereRaw("SalesReps.id = $salesRepId")
        ->selectRaw(
            'SalesReps.id AS salesrep_id, 
            ApprovalReasons.id AS approvalreason_id,
            SalesRep_Division.division_id AS division_id,
            SalesRepTitles.salesrep_title AS title,
            0 AS default_permission, 
            "0000-00-00" as expiration_date'
        );
    }

}
