<?php

namespace Hilco\Models;

/**
 * Hilco\Models\Division
 *
 * @property mixed $id
 * @property string $division
 * @property string $division_name
 * @property string $date_created
 * @property string $date_modified
 * @property string $deleted_at
 * @property-read \Illuminate\Database\Eloquent\Collection|\Hilco\Models\Customer[] $customers
 * @property-read mixed $id_string
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Division whereId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Division whereDivision($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Division whereDivisionName($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Division whereDateCreated($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Division whereDateModified($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Division whereDeletedAt($value)
 * @mixin \Eloquent
 * @property string $date_uploaded
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Division whereDateUploaded($value)
 */
class Division extends WebModel {
	protected $table = 'Divisions';

	const AU_CODE = 'U02';
    const UK_CODE = 'G01';
    const US_CODE = 'U01';

    const LEGACY_DIVISIONS = ['HILCO-US', 'HILCO-UK', 'WILSON-US'];

    public function getDivisionTrimmedAttribute() {
        return trim(substr($this->division, strpos($this->division, '_') + 1));
    }

    public static function legacyDivisionIDs() {
        return Division::whereIn('division', self::LEGACY_DIVISIONS)->pluck('id');
    }
}
