<?php

namespace Hilco\Models;

class rulesChecker
{
	public static function checkPromoRules($promos, $part=null){
		$discount = [];
		if(isset($promos) && $promos->count() > 0){
			foreach($promos as $promo){
				$rulesCheck = [];
				$promoPassed = false;
				if(!isset($promo->rules)) continue;
				if($promo->rules->count()<=0){
					$promoPassed = true;
				}else{
					foreach ($promo->rules as $rule){
						if(isset($rulesCheck[$rule->rule_object_type]) && $rulesCheck[$rule->rule_object_type]) continue;
						$rulesCheck[$rule->rule_object_type] = self::rulesChecker($rule, $part);
					}
					if(!array_search(false,$rulesCheck)) $promoPassed = true;
				}
				if($promoPassed){
					$discount[$promo->type] = (isset($discount[$promo->type]))?$discount[$promo->type]+(int)$promo->bonus:(int)$promo->bonus;
				}
			}
		}
		return $discount;
	}

	protected static function rulesChecker($rule, $part){
		switch ($rule->rule_object_type){
			case 'customer':
				return self::customerRuleCheck($rule);
				break;

			case 'part-quantity':
				return self::partQuantityRuleCheck($rule, $part);
				break;

			case 'promo-code':
				return (isset($part))?self::promoCodeRuleCheck($rule):false;
				break;
		}
		return false;
	}

	public static function promoCodeRuleCheck($rule){
		$promoCodes = app('userPromoCode');
		if(!isset($promoCodes)) return false;
		$activatedCode =  $promoCodes->where('id',(int)$rule->rule_object_id);
		return (isset($activatedCode) && $activatedCode->count() > 0);
	}

	public static function customerRuleCheck($rule){
		$user = Auth::user();
		return (isset($user) && $user->customer_id == $rule->rule_object_id);
	}

	public static function partQuantityRuleCheck($rule, $part){
		$cartItems = App('cartSingleton')->getCartItems();
		if(gettype($cartItems) == 'array') return false;

		$cartItem = $cartItems->where('part_number',$part->part_number);
		return (isset($cartItem) && $cartItem->first()->quantity >= (int)$rule->rule_condition);
	}
}