<?php

namespace Hilco\Models;
use Illuminate\Database\Eloquent\Model;

/**
 * Hilco\Models\ProductCategoryGroups
 *
 * @property mixed $id
 * @property string $product_category_group
 * @property mixed $productcategorysummary_id
 * @property string $date_created
 * @property string $date_modified
 * @property string $deleted_at
 * @property-read \Hilco\Models\ProductCategorySummaries $categorySummary
 * @property-read \Hilco\Models\ProductCategory $category
 * @property-read \Hilco\Models\WebGroup $details
 * @property-read mixed $id_string
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\ProductCategoryGroup whereId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\ProductCategoryGroup whereProductCategoryGroup($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\ProductCategoryGroup whereProductcategorysummaryId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\ProductCategoryGroup whereDateCreated($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\ProductCategoryGroup whereDateModified($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\ProductCategoryGroup whereDeletedAt($value)
 * @mixin \Eloquent
 * @property string $date_uploaded
 * @property-read \Illuminate\Database\Eloquent\Collection|\Hilco\Models\ProductCategory[] $categories
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\ProductCategoryGroup whereDateUploaded($value)
 */
class ProductCategoryGroup extends Model
{
	protected $table = 'ProductCategoryGroups';
//	protected $with = 'details';
//	protected $fillable = ['name'];
//	protected $appends = ['name', 'category_count'];

	/**
	 * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
	 */
	public function categorySummary()
	{
		return $this->belongsTo(ProductCategorySummaries::class, 'productcategorysummary_id', 'id');
	}

	/**
	 * @return \Illuminate\Database\Eloquent\Relations\HasMany
	 */
	public function categories()
	{
		return $this->hasMany(ProductCategory::class, 'productcategorygroup_id', 'id');
	}

//	public function details() {
//		return $this->hasOne(WebGroup::class, 'productcategorygroup_id', 'id');
//	}
//
//	public function getNameAttribute() {
//		if ($this->details) return $this->details->product_category_group_display_name;
//	}
//
//	public function setNameAttribute($name) {
//		$this->details()->updateOrCreate([], ['product_category_group_display_name' => $name]);
//	}
//
//	public function getCategoryCountAttribute() {
//		if ($this->categories) return count($this->categories);
//		return 0;
//	}
//
//	public function getProductcategorygroupIdAttribute($value) {
//		return bin2hex($value);
//	}
}
