<?php

namespace Hilco\Models;

use DB;
use Hilco\Models\SelectsRelatedCount;

class Assetable extends WebModel
{
	protected $table = 'Assetables';
	protected $fillable = ['webasset_id', 'assetable_id', 'assetable_type', 'sequence', 'assetable_join_type', 'alt_text'];
	
    use HasModelTranslations;

    public function webAssets() {
        return $this->hasMany(WebAsset::class, 'webasset_id', 'id');
    }

    public function assetable() {
        return $this->morphTo();
    }

    public function getDisplayNameForUACAttribute() {
        $assetable = $this->assetable;
        return 'Asset (' . $this->attributes['assetable_join_type'] . ') for ' . $assetable->getDisplayNameForUACAttribute();
    }
}