<?php
/**
 * Created by PhpStorm.
 * User: brian
 * Date: 4/2/19
 * Time: 10:19 AM
 */

namespace Hilco\Models;

use Flynsarmy\DbBladeCompiler\Facades\DbView;
use Illuminate\Database\Eloquent\Model;
use Hilco\Models\WebModelTranslation;
use Illuminate\Support\Arr;

/**
 * Trait HasMetadata
 * @package Hilco\Models
 */
trait HasMetadata {
    public function metadata() {
        return $this->morphMany(WebMetadata::class, 'metadatable');
    }

    public function getMetadata($name) {
        return Arr::get($this->metadata->where('meta_name', $name)->first(), 'meta_value', '');
    }

    public function setMetadata($name, $value) {
        $metadata = $this->metadata()->where('meta_name', $name)->first();

        if (strlen($value)) {
            if (is_null($metadata)) {
                $this->metadata()->updateOrCreate([
                    'meta_name' => $name,
                    'meta_value' => $value,
                ]);
            } else {
                $metadata->meta_value = $value;
                $metadata->save();
            }
        } else {
            if (!is_null($metadata)) {
                $metadata->delete();
            }
        }
    }
}