@if($edit)
    <div class="mceNonEditable component-container" data-component-key="children"
        data-children-type="{{ $type }}"
        data-children-layout="{{ $layout }}"
        data-children-show-names="{{ $showNames }}"
    >
        <a href="#" class="btn btn-danger pull-right delete-component">X</a>
        <h4>@lang('hilco::app.container_children')</h4>
        <p>@lang('hilco::app.displays_the_children_of_this_container')</p>
        <div>
            @lang('hilco::app.type_colon') <div style="display: inline;" class="children-type"> {{ array_get($types, $type) }}</div><br>
            @lang('hilco::app.layout_colon') <div style="display: inline;" class="children-layout"> {{ array_get($layouts, $layout) }}</div><br>
            @lang('hilco::app.show_child_names_question_colon') <div style="display: inline;" class="children-show-names"> {{ $showNames ? trans('hilco::app.yes') : trans('hilco::app.no') }}</div><br>
        </div>
        <a href="#" class="children-settings-button btn btn-primary">@lang('hilco::app.configure')</a>
    </div>
@endif

@if($script)
    <script type="text/javascript">
        registerComponent('children', {
            menuText: '@lang('hilco::app.container_children')',
            bladeTemplate: 'hilco::components.children',
            init: function (body) {
                $(body).on('click', 'a.children-settings-button', function () {
                    var component = $(this).closest('.component-container');
                    var data = {
                        type: $(component).data('children-type'),
                        layout: $(component).data('children-layout'),
                        showNames: $(component).data('children-show-names'),
                    };
                    var types = {!! json_encode($types) !!};
                    var layouts = {!! json_encode($layouts) !!};

                    function buildList(list, data) {
                        var items = [];
                        $.each(list, function (key, value) {
                            items.push({
                                text: value,
                                value: key,
                                selected: data.layout == key,
                            });
                        });
                        return items;
                    }

                    win = tinymce.activeEditor.windowManager.open({
                        title: '@lang('hilco::app.configure_container_children')',
                        data: data,
                        body: [
                            {
                                name: 'type',
                                type: 'listbox',
                                label: '@lang('hilco::app.type')',
                                values: buildList(types, data),
                            },
                            {
                                name: 'layout',
                                type: 'listbox',
                                label: '@lang('hilco::app.layout')',
                                values: buildList(layouts, data),
                            },
                            {
                                name: 'showNames',
                                type: 'checkbox',
                                checked: $(component).data('children-show-names'),
                                label: '@lang('hilco::app.show_child_names_question')',
                            },
                        ],
                        onSubmit: function (e) {
                            data = tinymce.extend(data, e.data);
                            component
                                    .data('children-type', data.type)
                                    .data('children-layout', data.layout)
                                    .data('children-show-names', data.showNames)
                                    .attr('data-children-type', data.type)
                                    .attr('data-children-layout', data.layout)
                                    .attr('data-children-show-names', data.showNames)
                            ;
                            component.find('.children-type').text(types[data.type]);
                            component.find('.children-layout').text(layouts[data.layout]);
                            component.find('.children-show-names').text(data.showNames ? 'Yes' : 'No');
                        }
                    })
                });
            },
            serialize: function (componentNode) {
                return {
                    type: $(componentNode).data('children-type'),
                    layout: $(componentNode).data('children-layout'),
                    showNames: $(componentNode).data('children-show-names'),
                };
            },
        });
    </script>
@endif

@if($view)
    @if(isset($lpModel) && $lpModel->$type->count())
        @if($layout == 'normal')
        <div class="row row-centered">
        @elseif($layout == 'large' || $layout == 'jumbo')
        <div class="row container center-block row-centered">
        @endif
            @foreach($lpModel->$type as $child)
                @if($layout == 'jumbo')
                    <div class="col-sm-6 col-centered">
                @else
                    <div class="col-tn-12 col-xs-6 col-sm-4 col-lg-3 col-centered">
                @endif
                    @if($layout == 'normal')
                        <a href="{{$child->slugUrl()}}" class="thumbnail">
                            <div class="image" style="min-height: 100px; padding-top: 15px">
                                <img src="{{ $child->featuredImage(325, 125) }}" alt="{{$child->name}}" class="img img-responsive center-block" style="max-height: 150px">
                            </div>
                            @if($showNames)
                                <div class="caption text-center">
                                    <h4>{{ $child->name }}</h4>
                                </div>
                            @endif
                        </a>
                    @elseif($layout == 'large' | $layout == 'jumbo')
                        <a href="{{$child->slugUrl()}}">
                            <div class="image" style="min-height: 100px; padding-top: 15px">
                                <img src="{{ $child->featuredImage() }}" class="img img-responsive center-block">
                            </div>
                            @if($showNames)
                                <div class="caption text-center">
                                    <h4>{{ $child->name }}</h4>
                                </div>
                            @endif
                        </a>
                    @endif
                </div>
            @endforeach
            @if($layout == 'large') <div class="clearfix" style="margin-bottom: 20px"></div> @endif
        </div>
    @endif
@endif
