<?php

namespace Hilco\Models;

use Illuminate\Database\Eloquent\Model;

class WebFamily_Solr extends Model
{
    protected $table = 'WebFamily_Solr';
    protected $fillable = ['webFamily_id', 'hash', 'visible', 'lastAction'];

    const UPDATED_AT = 'date_modified';
    const CREATED_AT = 'date_created';

    use \Hilco\SoftDeletes;

    public function item() {
        return $this->belongsTo(WebFamily::class, 'webFamily_id', 'id');
    }

    public function scopeByDeletedRecords($query) {
        return $query
            ->whereRaw("(lastAction IN ('Added', 'Updated') OR visible != 0)")
            ->whereDoesntHave('item', function ($query) {
                $query
                    ->has('webCollections.webCategories.webGroups')
                    ->whereHas('webParts', function ($query) {
                        $query->where('is_visible', 1)->has('part');
                    });
            });
    }
}