<?php

namespace Hilco\Models;
use Eloquent;
use Hilco\SoftDeletes;
use URL;

/**
 * Hilco\Models\Plant
 *
 * @property mixed $id
 * @property string $plant
 * @property string $plant_name
 * @property string $date_created
 * @property string $date_modified
 * @property string $deleted_at
 * @property-read mixed $id_string
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Plant whereId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Plant wherePlant($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Plant wherePlantName($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Plant whereDateCreated($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Plant whereDateModified($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Plant whereDeletedAt($value)
 * @mixin \Eloquent
 * @property string $date_uploaded
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Plant whereDateUploaded($value)
 */
class Plant extends Eloquent
{
	protected $table = 'Plants';

	const AUSTRALIA_CODE    = 'U81';
	const BOZEMAN_CODE      = 'U41';
	const DALLAS_CODE       = 'U21';
    const HAWES_CODE        = 'G11';
    const LASVEGAS_CODE     = 'U31';
	const PLAINVILLE_CODE   = 'U11';

	public function plantAddress() {
	    return $this->hasOne(PlantAddress::class, 'plant_id', 'id');
    }

    public static function defaultPlant() {
	    if (strpos(URL::current(), '.co.uk')) {
	        return self::where('plant', '=', Plant::HAWES_CODE)->first();
        }
	    if (strpos(URL::current(), '.com.au')) {
	        return self::where('plant', '=', Plant::AUSTRALIA_CODE)->first();
        }
	    return self::where('plant', '=', Plant::PLAINVILLE_CODE)->first();
    }

    /**
     * @return array
     * @deprecated Pretty sure this was only actively used by InventoryItem::getInStockAttribute(), and the in_stock attribute isn't used anymore
     */
    public static function lasVegasLogicPlants() {
	    return [
	        Plant::PLAINVILLE_CODE,
            Plant::LASVEGAS_CODE,
        ];
    }

    /**
     * @return array of warehouse (plant) codes that are used in web inventory cluster logic
     */
    public static function inventoryClusterLogicPlants() {
	    return [
            Plant::PLAINVILLE_CODE,
	        Plant::LASVEGAS_CODE,
        ];
    }

    use SoftDeletes;
}
