<?php

namespace Hilco\Models;

use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * Hilco\Models\WebUserApprover
 * @property integer $id
 * @property integer $child_webuser_id
 * @property integer $parent_webuser_id
 * @property integer $confirmation_delay_days
 */
class WebUserApprover extends WebModel {
    protected $table = 'WebUserApprovers';
    protected $fillable = [
        'child_webuser_id', 'parent_webuser_id', 'confirmation_delay_days',
        'createdby_user_id', 'lasteditedby_user_id'
    ];

    /**
     * @return BelongsTo
     */
    public function childWebUser(): BelongsTo {
        return $this->belongsTo(WebUser::class, 'child_webuser_id', 'id');
    }

    /**
     * @return BelongsTo
     */
    public function parentWebUser(): BelongsTo {
        return $this->belongsTo(WebUser::class, 'parent_webuser_id', 'id');
    }
}