<?php

namespace Hilco\Models;

class ApprovalEmailRecord extends WebModel {
    protected $table = 'ApprovalEmailRecords';
    protected $fillable = [
        'order_reference_number', 'salesorder_id',
        'webuserapprover_id', 'webuser_id',
        'email_sent_status', 'email_used'
    ];

    /**
     * @param array $createData {order_reference_number: string, salesorder_id: int, webuserapprover_id: int, webuser_id: int, email_sent_status: string, email_used: string}
     */
    public static function createApprovalEmailRecord (array $createData) {
        $approvalEmailRecord = new ApprovalEmailRecord();
        $approvalEmailRecord->order_reference_number = $createData['order_reference_number'];
        $approvalEmailRecord->salesorder_id = $createData['salesorder_id'];
        $approvalEmailRecord->webuserapprover_id = $createData['webuserapprover_id'];
        $approvalEmailRecord->webuser_id = $createData['webuser_id'];
        $approvalEmailRecord->email_sent_status = $createData['email_sent_status'];
        $approvalEmailRecord->email_used = $createData['email_used'];
        $approvalEmailRecord->save();
    }
}