<?php

namespace Hilco\Models;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\MorphTo;
use Illuminate\Database\Eloquent\Relations\Relation;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;
use LogicException;

class PromotionOrderDiscountAction extends PromotionActionDetails
{
    protected $table = 'PromotionOrderDiscountActions';
    protected $fillable = ['discount_percent', 'maximum_dollar_amount'];

    public function promotion() {
        return $this->morphToMany(Promotion::class, 'action', 'PromotionActions', 'promotion_id', 'promotionorderdiscountaction_id');
    }

    public function takeAction(Customer $soldToCustomer, $webCartItems, &$status) {

    }
}
