<?php

namespace Hilco\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Support\Collection;
use Venturecraft\Revisionable\RevisionableTrait;

class WebSilo extends HierarchyModel implements HasLandingPageInterface {
	protected $table = "WebSilos";
	protected $fillable = ['name', 'webRoleIds', 'is_visible', 'is_default', 'detail', 'default_price_list', 'contact_phone', 'contact_email', 'web_urls', 'divisions', 'web_customer_types', 'customer_category_summaries'];
	protected $casts = [
	    'is_visible' => 'boolean'
	];

	public function webGroups() {
		return $this->belongsToMany(WebGroup::class, 'WebGroup_WebSilo', 'websilo_id', 'webgroup_id');
	}

	public function webLinkCategories() {
		return $this->belongsToMany(WebCategory::class, 'WebLinkCategory_WebSilo', 'websilo_id', 'weblinkcategory_id');
	}

	public function webLinks() {
		return $this->belongsToMany(WebCategory::class, 'WebLink_WebSilo', 'websilo_id', 'weblink_id');
	}

	public function webRoles() {
		return $this->belongsToMany(Role::class, 'Role_WebSilo', 'websilo_id', 'role_id');
	}

	public function featuredChildren() {
	    return $this->webGroups();
    }

//    public function webUrlRules() {
//        return $this->belongsToMany(WebUrl::class, 'WebSilo_WebUrl', 'websilo_id', 'weburl_id');
//    }

    public function divisionRules() {
        return $this->belongsToMany(Division::class, 'WebSilo_Division', 'websilo_id', 'division_id');
    }

    public function customerCategorySummaryRules() {
        return $this->belongsToMany(CustomerCategorySummary::class, 'WebSilo_CustomerCategorySummary', 'websilo_id', 'customercategorysummary_id');
    }

    public function webCustomerTypeRules() {
        return $this->belongsToMany(WebCustomerType::class, 'WebSilo_WebCustomerType', 'websilo_id', 'webcustomertype_id');
    }
//
//    public function getWebUrlsAttribute() {
//        return $this->webUrlRules->pluck('id')->toArray();
//    }

//    public function setWebUrlsAttribute($ids) {
//        $this->webUrlRules()->sync($ids);
//    }

    public function getDivisionsAttribute() {
        return $this->divisionRules->pluck('id')->toArray();
    }

    public function setDivisionsAttribute($ids) {
        $this->divisionRules()->sync($ids);
    }

    public function getCustomerCategorySummariesAttribute() {
        return $this->customerCategorySummaryRules->pluck('id')->toArray();
    }

    public function setCustomerCategorySummariesAttribute($ids) {
        $this->customerCategorySummaryRules()->sync($ids);
    }

    public function getWebCustomerTypesAttribute() {
        return $this->webCustomerTypeRules->pluck('id')->toArray();
    }

    public function setWebCustomerTypesAttribute($ids) {
        $this->webCustomerTypeRules()->sync($ids);
    }

    /**
     * @return BelongsToMany $this
     */
    public function plants() {
        return $this->belongsToMany(Plant::class, 'Plant_WebSilo', 'websilo_id', 'plant_id')->withPivot('web_flags');
    }

	public function setWebRoleIdsAttribute($ids) {
		$this->save();
		$this->webRoles()->sync($ids);
	}

	public function getAssetPrefix() {
		return "WebSilos/{$this->id}/webContexts";
	}

	public function scopeVisible(Builder $query) {
		return $query
			->where('WebSilos.is_visible', '1')
//			->whereHas('webGroups', function ($query) {
//				return $query->visible();
//			})
		;
	}

	public static function current() {
	    $webSilo = null;
        if (auth()->user()) {
//            $customer = auth()->user()->customer;
//            dd($customer);
        } else {
            $webUrl = WebUrl::current($_SERVER['HTTP_HOST']);
            if (!is_null($webUrl)) $webSilo = $webUrl->webSilo;
        }
        if (is_null($webSilo)) $webSilo = WebSilo::first();
        return $webSilo;
    }

    public function slugUrl() {
        //return route('silos.slug', [$this->slug]);
    }

    use HasSlug, HasLandingPage, RevisionableTrait;
}
