<?php

namespace Hilco\Models;

use Illuminate\Support\Facades\Auth;
use DB;
/**
 * Hilco\Models\WebLandingPage
 *
 * @property integer $id
 * @property string $position
 * @property string $title
 * @property string $date_modified
 * @property string $date_created
 * @property string $deleted_at
 */
class WebLinkCategory extends WebModel {
    protected $table = "WebLinkCategories";
    protected $fillable = ['position','title','order','webSiloIds'];
    public static $positions =['hb2b-footer'=>'Hilco footer','hb2b-header'=>'Hilco header'];

    public function links() {
        return $this->hasMany(WebLink::class, 'web_link_category_id');
    }

    public function webSilos() {
        return $this->belongsToMany(WebSilo::class, 'WebLinkCategory_WebSilo', 'weblinkcategory_id', 'websilo_id');
    }

    public function setWebSiloIdsAttribute($ids) {
        $this->save();
        $this->webSilos()->sync($ids);
    }

    public function scopeAvailableForUser($query){
        $user = Auth::user();
        $usrRoles = (isset($user))?$user->roles:null;
        return $query
            ->leftJoin('WebLinkCategory_WebSilo as WLCWS', 'WLCWS.weblinkcategory_id', '=', 'WebLinkCategories.id')
            ->leftJoin('WebSilos as WS', 'WS.id', '=', 'WLCWS.websilo_id')
            ->leftJoin('Role_WebSilo as RWS', 'RWS.websilo_id', '=', 'WLCWS.websilo_id')
            ->select(DB::raw('WebLinkCategories.*'))
            ->where(function($query)use($usrRoles){
                if (isset($usrRoles)){
                    return $query->whereIn('RWS.role_id',$usrRoles->pluck('id'))->where('WS.is_visible','1')->orWhereNull('RWS.role_id');
                }else{
                    return $query->whereNull('RWS.role_id');
                }
            });
    }

    public function scopeInFooter($query){
        return $query->where('position', 'hb2b-footer');
    }

}
