<div class="panel panel-info" id="component-{{ $id }}">
    <div class="panel-heading">
        <h3 class="panel-title pull-left" style="white-space: nowrap; overflow: hidden; text-overflow: ellipsis; line-height: normal; padding-top: 8px;">{{ $name }}</h3>
        <div class="pull-right">
            <button class="btn btn-default">
                Move Up <i class="fa fa-arrow-up"></i>
            </button>
            <button class="btn btn-default">
                Move Down <i class="fa fa-arrow-down"></i>
            </button>
            <button class="btn btn-danger remove-component-button" id="remove-component-{{ $id }}">
                Remove <i class="fa fa-trash"></i>
            </button>
        </div>
        <div class="clearfix"></div>
    </div>
    <div id="component-{{ $id }}" class="panel-body">
        @foreach ($fields as $field)
            <div class="form-group">
                {!! Form::label($field['name'], $field['label']) !!}
                @if($field['type'] == 'select')
                    {!! Form::select($field['name'], $field['options'], $field['value'], ['class' => 'form-control component-option']) !!}
                @elseif($field['type'] == 'textarea')
                    {!! Form::textarea($field['name'], $field['value'], ['class' => 'form-control component-option']) !!}
                @elseif($field['type'] == 'text')
                    {!! Form::text($field['name'], $field['value'], ['class' => 'form-control component-option']) !!}
                @endif
            </div>
        @endforeach
        <button class="btn btn-primary save-component-button" id="save-component-{{ $id }}">
            Save <i class="fa fa-save"></i>
        </button>
    </div>
</div>