<?php

namespace Hilco\Models;

/**
 * Class WebSiloBlockedPage
 * @package Hilco\Models
 * @property integer $websilo_id
 * @property integer $weblandingpage_id
 * @method static \Illuminate\Database\Query\Builder bySiloPage($value,$value)
 */
class WebSiloBlockedPage extends WebModel {
    protected $table = 'WebSiloBlockedPages';
    protected $fillable = ['websilo_id', 'weblandingpage_id'];

    public function webSilo() {
        return $this->belongsTo(WebSilo::class, 'websilo_id', 'id');
    }

    public function webLandingPage() {
        return $this->belongsTo(WebLandingPage::class, 'weblandingpage_id', 'id');
    }

    public function scopeBySiloPage ($query, $webSiloId, $webLandingPageId) {
        return $query->whereRaw("websilo_id = ? AND weblandingpage_id = ?", [$webSiloId, $webLandingPageId]);
    }
}