<?php

namespace Hilco\Models;

use Hilco\Models\UuidModel;
use Throwable;

/**
 * Hilco\Models\VWLineDiscount
 *
 * @property mixed $id
 * @property mixed $salesorderdiscline_id
 * @property string $factor
 * @property string $discount_code
 * @property string $discount_desc
 * @property float $discount_amount
 * @property float $discount_percent
 * @property string $discounttype_table
 * @property integer $discounttypetable_id
 * @property string $date_created
 * @property string $date_modified
 * @property string $date_uploaded
 * @property string $deleted_at
 * @property integer $commit_sequence
 * @property boolean $is_manual_discount
 */
class VWLineDiscount extends UuidModel {
    protected $table = "VWLineDiscounts";
    protected $fillable = [
        'id',
        'discount_factor', 'discountfactor_value',
        'discount_code', 'discount_desc',
        'discount_amount', 'discount_percent',
        'discounttype_table', 'discounttypetable_id',
        'is_manual_discount',
        'salesorderdiscline_id',
        'commit_sequence'
    ];

    /**
     * @param StagedOneOffLineDiscount $stagedOneOffLineDiscount
     * @param int $commit_sequence
     * @return VWLineDiscount
     * @throws Throwable
     */
    public static function createFromStaged (StagedOneOffLineDiscount $stagedOneOffLineDiscount, int $commit_sequence): VWLineDiscount {
        $stagedOrderDiscLine = $stagedOneOffLineDiscount->stagedOrderDiscLine;
        $salesOrderDiscLine = $stagedOrderDiscLine->salesOrderDiscLine;
        $vwLineDiscount = new VWLineDiscount([
            'id' => generateUUID(),
            'salesorderdiscline_id' => $salesOrderDiscLine->id,
            'discount_factor' => $stagedOneOffLineDiscount->getDiscountFactor(),
            'discountfactory_value' => $stagedOneOffLineDiscount->getDiscountFactorValue(),
            'discount_code' => $stagedOneOffLineDiscount->getDiscountCode(),
            'discount_desc' => $stagedOneOffLineDiscount->getDiscountDesc(),
            'discount_amount' => $stagedOneOffLineDiscount->getDiscountAmount(),
            'discount_percent' => $stagedOneOffLineDiscount->getDiscountPercent(),
            'discounttype_table' => $stagedOneOffLineDiscount->discounttype_table,
            'discounttypetable_id' => $stagedOneOffLineDiscount->discounttypetable_id,
            'is_manual_discount' => $stagedOneOffLineDiscount->isManualDiscount(),
            'commit_sequence' => $commit_sequence,
        ]);
        $vwLineDiscount->saveOrFail();
        return $vwLineDiscount;
    }
}