<?php

namespace Hilco\Models;

class PromotionItemDiscountAction extends PromotionActionDetails {
    protected $table = 'PromotionItemDiscountActions';
    protected $fillable = ['quantity_to_discount', 'discount_percent', 'discount_entire_order', 'discount_note', 'commit_sequence'];

    public function promotion() {
        return $this->morphToMany(Promotion::class, 'action',
                                'PromotionActions', 'promotion_id',
                        'promotionitemdiscountaction_id');
    }

    public function webGroups() {
        return $this
            ->morphedByMany(WebGroup::class, 'product',
                            'PromotionItemDiscountAction_Product', 'promotionitemdiscountaction_id')
            ->withPivot(['excluded'])
            ->whereNull('PromotionItemDiscountAction_Product.deleted_at')
        ;
    }

    public function webCategories() {
        return $this
            ->morphedByMany(WebCategory::class, 'product',
                            'PromotionItemDiscountAction_Product', 'promotionitemdiscountaction_id')
            ->withPivot(['excluded'])
            ->whereNull('PromotionItemDiscountAction_Product.deleted_at')
        ;
    }

    public function webCollections() {
        return $this
            ->morphedByMany(WebCollection::class, 'product',
                            'PromotionItemDiscountAction_Product', 'promotionitemdiscountaction_id')
            ->withPivot(['excluded'])
            ->whereNull('PromotionItemDiscountAction_Product.deleted_at')
        ;
    }

    public function webFamilies() {
        return $this
            ->morphedByMany(WebFamily::class, 'product',
                            'PromotionItemDiscountAction_Product', 'promotionitemdiscountaction_id')
            ->withPivot(['excluded'])
            ->whereNull('PromotionItemDiscountAction_Product.deleted_at')
        ;
    }

    public function webParts() {
        return $this
            ->morphedByMany(WebPart::class, 'product',
                            'PromotionItemDiscountAction_Product', 'promotionitemdiscountaction_id')
            ->withPivot(['excluded'])
            ->whereNull('PromotionItemDiscountAction_Product.deleted_at')
        ;
    }

    public function getRelationForProductTableType($tableType) {
        //
        if($tableType === 'webFamily' || $tableType === 'webCategory') {
            $relationName = substr($tableType, 0, -1);
            $relationName .= 'ies';
        } else {
            $relationName = $tableType . 's';
        }
        return $this->$relationName();
    }

    public function isApplicable(Part $part) {
        if ($this->discount_entire_order)
            return true;

        $validWebGroupIds = $this->webGroups->pluck('id')->toArray();
        $validWebCategoryIds = $this->webCategories->pluck('id')->toArray();
        $validWebCollectionIds = $this->webCollections->pluck('id')->toArray();
        $validWebFamilyIds = $this->webFamilies->pluck('id')->toArray();
        $validWebPartIds = $this->webParts->pluck('id')->toArray();

        $webPart = \Illuminate\Support\Arr::get($part, 'webPart');
        if (count($validWebPartIds) && in_array($webPart->id, $validWebPartIds))
            return true;

        $webFamily = \Illuminate\Support\Arr::get($webPart, 'webFamily');
        if (count($validWebFamilyIds) && in_array($webFamily->id, $validWebFamilyIds))
            return true;

        foreach (\Illuminate\Support\Arr::get($webFamily, 'webCollections', []) as $webCollection) {
            if (count($validWebCollectionIds) && in_array($webCollection->id, $validWebCollectionIds))
                return true;

            foreach (\Illuminate\Support\Arr::get($webCollection, 'webCategories', []) as $webCategory) {
                if (count($validWebCategoryIds) && in_array($webCategory->id, $validWebCategoryIds))
                    return true;

                foreach (\Illuminate\Support\Arr::get($webCategory, 'webGroups', []) as $webGroup) {
                    if (count($validWebGroupIds) && in_array($webGroup->id, $validWebGroupIds))
                        return true;
                }
            }
        }

        return false;
    }

    public function takeAction(Customer $soldToCustomer, $webCartItems, &$status) {
        // TODO: Implement takeAction() method
        if($this->discount_entire_order){
            foreach($status['items'] as $item) {
                $discountPercent = $this->discountPercent;
                $discountAmount = round($item['basePrice'] * ($discountPercent / 100), 2);
                $extendedDiscountAmount = $discountAmount * $item['quantity'];
                $baseDiscountAmount = round($item['basePrice'] * ($discountPercent / 100), 2);
                $discountedPrice = $item['basePrice'] - $baseDiscountAmount;
                $extendedPrice = $discountedPrice * $item['quantity'];

            }
        } else {
//            foreach($status['items'] as $item) {
//                if ($this->isApplicable($item)) {
//                    $discountPercent = $this->discountPercent;
//                    $discountAmount = round($item['basePrice'] * ($discountPercent / 100), 2);
//                    $extendedDiscountAmount = $discountAmount * $item['quantity'];
//                    $baseDiscountAmount = round($item['basePrice'] * ($discountPercent / 100), 2);
//                    $discountedPrice = $item['basePrice'] - $baseDiscountAmount;
//                    $extendedPrice = $discountedPrice * $item['quantity'];
//                }
//            }
        }
    }

    public static function boot() {
        parent::boot();

        static::deleted(function (PromotionItemDiscountAction $promotionItemDiscountAction) {
            $promotionItemDiscountActionProducts =
                PromotionItemDiscountAction_Product::where('promotionitemdiscountaction_id', '=', $promotionItemDiscountAction->id);
            foreach ($promotionItemDiscountActionProducts as $promotionItemDiscountActionProduct) {
                $promotionItemDiscountActionProduct->delete();
            }
        });
    }
}
