<?php

namespace Hilco\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * Hilco\Model\Promotion_StagedOrder
 * @property integer id
 * @property integer promotion_id
 * @property integer stagedorder_id
 * @property boolean applied
 * @property Promotion promotion
 * @property StagedOrder stagedOrder
 * @method static Builder byPromotionStagedOrder($promotion, $stagedOrder)
 */
class Promotion_StagedOrder extends StagingModel {
    protected $table = "Promotion_StagedOrder";

    /**
     * @return bool
     */
    public function isApplied(): bool {
        return $this->applied;
    }

    /**
     * @return BelongsTo
     */
    public function promotion(): BelongsTo {
        return $this->belongsTo(Promotion::class, "promotion_id", "id");
    }

    /**
     * @return BelongsTo
     */
    public function stagedOrder(): BelongsTo {
        return $this->belongsTo(StagedOrder::class, "stagedorder_id", "id");
    }

    public function scopeByPromotionStagedOrder ($query, Promotion $promotion, StagedOrder $stagedOrder) {
        return $query->where("promotion_id", $promotion->id)->where('stagedorder_id', $stagedOrder->id);
    }
}