<?php

namespace Hilco\Models;


use Illuminate\Database\Query\Builder;
use Throwable;

/**
 * Hilco\Models\OrderAttnLine
 *
 * @property mixed $id
 * @property-read mixed $id_string
 * @property mixed $salesorder_id
 * @property string $date_created
 * @property string $status
 * @property string $auth_reference_num
 * @property string $authorization_code
 * @property string $last_four_digits
 * @property string $authorized_amount
 * @property string $date_authorized
 * @property string $origin
 * @property string $date_modified
 * @property string $date_uploaded
 * @property string $deleted_at
 * @property string $onetime_auth
 * @property string $void_code
 * @property string $void_reference_num
 * @method static Builder|OrderAttnLine whereId($value)
 * @method static Builder|OrderAttnLine whereDateCreated($value)
 * @method static Builder|OrderAttnLine whereDateModified($value)
 * @method static Builder|OrderAttnLine whereDateUploaded($value)
 * @method static Builder|OrderAttnLine whereDeletedAt($value)
 * @method static Builder|OrderAttnLine whereSalesorderId($value)
 * @mixin \Eloquent
 */
class CreditCardAuthorization extends UuidModel {
    protected $table = 'CreditCardAuthorizations';
    protected $fillable = [
        'id', 'salesorder_id', 'status',
        'authorization_code', 'auth_reference_num', 'authorized_amount',
        'last_four_digits', 'date_authorized',
        'origin', 'onetime_auth',
    ];

    /**
     * @param CenposAuthorization $cenposAuthorization
     * @return CreditCardAuthorization
     * @throws Throwable
     */
    public static function createFromStaged (CenposAuthorization $cenposAuthorization): CreditCardAuthorization {
        $stagedOrder = $cenposAuthorization->stagedOrder;
        $salesOrder = $stagedOrder->salesOrder;
        $creditCardAuthorization = new CreditCardAuthorization([
            'id' => generateUUID(),
            'salesorder_id' => $salesOrder->id,
            'status' => $cenposAuthorization->getStatus(),
            'authorization_code' => $cenposAuthorization->getAuthCode(),
            'auth_reference_num' => $cenposAuthorization->getAuthReferenceNum(),
            'authorized_amount' => $cenposAuthorization->getAuthorizedAmount(),
            'last_four_digits' => $cenposAuthorization->getLastFour(),
            'date_authorized' => $cenposAuthorization->getDateAuthorized(),
            'origin' => Order::CST_WEB_ORDER_ORIGIN,
            'onetime_auth' => $cenposAuthorization->isOneTimeAuth(),
        ]);
        $creditCardAuthorization->saveOrFail();
        return $creditCardAuthorization;
    }

    public function salesOrder() {
        return $this->belongsTo(Order::class, 'salesorder_id', 'id');
    }
}
