<?php

namespace Hilco\Models;

/**
 * Hilco\Models\CustomerCategory
 *
 * @property mixed $id
 * @property string $cust_category
 * @property string $cust_category_desc
 * @property string $cust_cat_group
 * @property string $cust_cat_summary
 * @property string $date_created
 * @property string $date_modified
 * @property string $deleted_at
 * @property-read \Illuminate\Database\Eloquent\Collection|\Hilco\Models\Customer[] $customers
 * @property-read mixed $id_string
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerCategory whereId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerCategory whereCustCategory($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerCategory whereCustCategoryDesc($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerCategory whereCustCatGroup($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerCategory whereCustCatSummary($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerCategory whereDateCreated($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerCategory whereDateModified($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerCategory whereDeletedAt($value)
 * @mixin \Eloquent
 * @property string $date_uploaded
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerCategory whereDateUploaded($value)
 */
class CustomerCategory extends UuidModel {
	protected $table = 'CustomerCategories';

	public function customers()
	{
		return $this->hasMany(Customer::class, 'customercategory_id');
	}

    public function getCustCategory() {
        return $this->cust_category;
    }

    public function getCustCategoryDesc() {
        return $this->cust_category_desc;
    }
}
