<?php
/**
 * Created by PhpStorm.
 * User: brian
 * Date: 4/2/19
 * Time: 10:13 AM
 */

namespace Hilco\Models;


use DB;
use Illuminate\Database\Query\JoinClause;
use Illuminate\Support\Facades\Blade;
use Illuminate\Support\Str;

/**
 * Hilco\Models\WebModelTranslation
 * @property integer $translatable_id
 * @property string $translatable_type
 * @property string $language
 * @property string $column_name
 * @property string $translation
 * @property boolean $from_syndigo
 */
class WebModelTranslation extends WebModel {

    protected $table = 'WebModelTranslations';
    protected $fillable = [
        'translatable_id', 'translatable_type',
        'column_name', 'translation',
        'language', 'from_syndigo'
    ];

    public function translatable()
    {
        return $this->morphTo();
    }

    public function scopeExportQuery($query, $language, $hasTrans) {
        $defaultLangCode = AvailableLanguage::DEFAULT_LANG_CODE;

        return $query
            ->select([
                'WebModelTranslations.id',
                'WebModelTranslations.translatable_id',
                'WebModelTranslations.translatable_type',
                'WebModelTranslations.column_name',
                'WebModelTranslations.translation as english_source',
                'AvailableLanguages.language_code',
                'wmtInner.translation as translation'
            ])
            ->join('AvailableLanguages', DB::raw('1'), '=', DB::raw('1'))
            ->leftJoin('WebModelTranslations as wmtInner', function(JoinClause $join){
                $join
                    ->on('WebModelTranslations.translatable_id', '=', 'wmtInner.translatable_id')
                    ->on('WebModelTranslations.translatable_type', '=', 'wmtInner.translatable_type')
                    ->on('WebModelTranslations.column_name', '=', 'wmtInner.column_name')
                    ->on('wmtInner.language', '=', 'AvailableLanguages.language_code')
                    ->where('wmtInner.deleted_at', '=', '0000-00-00 00:00:00');
            })
            ->where('WebModelTranslations.deleted_at', '=', '0000-00-00 00:00:00')
            ->where('WebModelTranslations.language', '=', $defaultLangCode);
    }

    public function scopeByIdTypeColumnLang ($query, $translatable_id, $translatable_type, $column_name, $language) {
        return
            $query
                ->where('translatable_id', '=', $translatable_id)
                ->where('translatable_type', '=', $translatable_type)
                ->where('column_name', '=', $column_name)
                ->where('language', '=', $language);
    }

    public function setTranslationAttribute ($translation) {
        if ($this->column_name == 'detail') {
            if (Str::contains($translation, 'mceNonEditable')) {
                throw new \InvalidArgumentException(trans('hilco::app.error_while_saving_details_please_try_again'));
            }

            $newTranslation = preg_replace_callback('%<!--\\[\\[\\[(.*?)\|(.*?)\\]\\]\\]-->%', function ($matches) {
                return "@include('$matches[1]', " . str_replace(["\n", "\r"], '', var_export(json_decode($matches[2], true), true)) . ")";
            }, $translation);

            $this->attributes['translation'] = $newTranslation;
        } else {
            $this->attributes['translation'] = $translation;
        }
    }

    public function getTranslationForEditAttribute() {
        return Blade::render($this->translation, ['edit' => true, 'wrap' => true]);
    }
}