<?php

namespace Hilco\Models;

/**
 * Class PromotionCustomerTrigger_Customer
 * @package Hilco\Models
 */
class PromotionCustomerTrigger_Customer extends WebModel {
    protected $table = 'PromotionCustomerTrigger_Customer';
    protected $fillable = ['promotioncustomertrigger_id', 'customer_id', 'excluded', 'commit_sequence'];

    /**
     * Get the relationship to owning PromotionCustomerTrigger
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function promotionCustomerTrigger() {
        return $this->belongsTo(PromotionCustomerTrigger::class,
            'promotioncustomertrigger_id', 'id');
    }

    /**
     * Get the relationship to the targeted Customer
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function customer() {
        return $this->belongsTo(Customer::class, 'customer_id', 'id');
    }


    // Scopes
    public function scopeTriggerCustomer($query, $trigger_id, $customer_id) {
        return $query
            ->where('promotioncustomertrigger_id', $trigger_id)
            ->where('customer_id', $customer_id)
            ;
    }

    public function scopeByCustomer($query, $customer_id) {
        return $query
            -> where('customer_id', $customer_id)
            ;
    }

    public function scopeByTrigger($query, $trigger_id) {
        return $query
            -> where('promotioncustomertrigger_id', $trigger_id)
            ;
    }

    use HasCommitSequence;
}