<?php
/**
 * Created by PhpStorm.
 * User: ntaylor
 * Date: 11/10/18
 * Time: 12:43 PM
 */

namespace Hilco\Models;

/**
 * Trait HasProductTableTypeRelationship
 * @package Hilco\Models
 */
trait HasProductTableTypeRelationship {
    /**
     * Gets the table name (relation) for the product type
     * e.g., product type 'webUnit' matches to table name WebUnits
     * @param $object
     * @param $tableType
     * @return mixed
     */
    public function getRelationForProductTableType($tableType) {
        if ($tableType === 'webFamily' || $tableType === 'webCategory') {
            $relationName = substr($tableType, 0, -1);
            $relationName .= 'ies';
        } else {
            $relationName = $tableType . 's';
        }
        return $relationName;
    }
}