<?php

namespace Hilco\Models;

/**
 * Class WebCollection_WebCategory
 * @package Hilco\Models
 * @property int $webcollection_id
 * @property int $webcategory_id
 * @property bool $is_featured
 * @property int $display_order
 */
class WebCollection_WebCategory extends WebModel {
    protected $table = 'WebCollection_WebCategory';
    protected $fillable = ['webcollection_id', 'webcategory_id', 'is_featured', 'display_order'];

    public static function createWebCollectionWebCategory (array $wcwcData) {
        return WebCollection_WebCategory::create($wcwcData);
    }

    public static function deleteWebCollectionWebCategory ($id) {
        WebCollection_WebCategory::find($id)->delete();
    }

    public function webCollection() {
        return $this->belongsTo(WebCollection::class, 'webcollection_id', 'id');
    }

    public function webCategory() {
        return $this->belongsTo(WebCategory::class, 'webcategory_id', 'id');
    }

    public function scopeByWCWC ($query, $webcollection_id, $webcategory_id) {
        return $query->where('webcollection_id', $webcollection_id)->where('webcategory_id', $webcategory_id);
    }
}