<?php

namespace Hilco\Models;

use Illuminate\Database\Eloquent\Relations\MorphTo;

/**
 * Hilco\Model\SyndigoAttribute
 * @property-read string $syndigo_name
 * @property-read integer $vwmodel_id
 * @property-read string $vwmodel_type
 * @property-read SyndigoAttributeType $vwmodel
 */
class SyndigoAttribute extends WebModel {
    protected $table = 'SyndigoAttributes';
    protected $fillable = [
        'syndigo_name','vwmodel_id','vwmodel_type'
    ];

    public function vwmodel(): MorphTo {
        return $this->morphTo();
    }
}