<?php

namespace Hilco\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Collection;

/**
 * Hilco\Models\SalesRepPermissions
 *
 * @property integer $id
 * @property string $salesrep_id
 * @property string $permission
 * @property string $allowed
 * @property string $date_created
 * @property string $date_modified
 * @property string $date_uploaded
 * @property string $deleted_at
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\SalesRepPermissions whereId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\SalesRepPermissions whereSalesRepId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\SalesRepPermissions wherePermission($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\SalesRepPermissions whereAllowed($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\SalesRepPermissions whereDateCreated($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\SalesRepPermissions whereDateModified($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\SalesRepPermissions whereDateUploaded($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\SalesRepPermissions whereDeletedAt($value)
 * @mixin \Eloquent
 */

class SalesRepPermissions extends Model {

    use \Hilco\SoftDeletes;

    protected $table = "SalesRepPermissions";
    protected $fillable = ['salesrep_id', 'permission', 'allowed'];

    const UPDATED_AT = 'date_modified';
    const CREATED_AT = 'date_created';

    public function scopeByRepPermission($query, $repId, $permission) {
        return $query
                ->where('salesrep_id', $repId)
                ->where('permission', $permission);
    }
}