<?php

namespace Hilco\Models;
use Illuminate\Database\Eloquent\Model;
use Hilco\SoftDeletes;


class CustomerAttributeList extends Model
{
    protected $table = 'CustomerAttributeLists';
    const CREATED_AT = 'date_created';
    const UPDATED_AT = 'date_modified';

    protected $fillable = ['list_name', 'deleted_at'];

    use SoftDeletes;

    public function attributes()
    {
        return $this->hasMany(CustomerAttribute::class, 'list_id');
    }

    public function deleteAttributes()
    {
        $this->attributes()->delete();
    }
}