@if(isset($mode) && $mode === 'view')
    <div>
        @if(Arr::get($slide, 'link')) <a href="{{ webLinkUrl($slide['link'], $alternateLogId ?? false) }}"> @endif
            <img src="{{ webAssetUrl($slide['webAssetId']) }}" alt="@if(isset($slide['alttag']))  {{ $slide['alttag'] }} @endif" />
            @if(Arr::get($slide, 'link')) </a> @endif
    </div>
@else
    <div data-view-id="{{$slideId}}" data-link-type="{{ Arr::get($slide, 'link.type') }}" data-link-target="{{ Arr::get($slide, 'link.target') }}" data-web-asset-id="{{ $slide['webAssetId'] }}" data-img-alttag="@if(isset($slide['alttag']))  {{ $slide['alttag'] }} @endif" data-target-customers="@if(isset($targetCustomers))  {{json_encode($targetCustomers)}} @endif" data-visible-dates="@if(isset($visibleDates))  {{json_encode($visibleDates)}} @endif" data-default-visibility="@if(isset($slide['defaultVisibility']))  {{$slide['defaultVisibility']}} @else Visible @endif" class="slide-container view-container {{$default? 'default visible' : 'alternate hidden'}}">
        <div style="margin: 5px; padding: 5px; border: 1px solid black; clear: both;">
            <img class="center-block img-responsive slide-thumbnail" src="{{ webAssetUrl($slide['webAssetId']) }}" alt="@if(isset($slide['alttag']))  {{ $slide['alttag'] }} @endif">
            @lang('hilco::app.destination_colon') <a href="#" class="slide-url">{!! strlen(webLinkTitle(Arr::get($slide, 'link', []))) ? webLinkTitle($slide['link']) : '<em>'.trans('hilco::app.none').'</em>' !!}</a><br>
            @lang('hilco::app.alternate_tag') <a href="#" class="slide-alttag">@if(isset($slide['alttag']) && trim($slide['alttag']) != "") {{ $slide['alttag'] }} @else None  @endif</a><br>
            @include('hilco::components.targetCustomer.visibilityControls', ['default' => $default ?? true, 'defaultVisibility' => $slide['defaultVisibility'] ?? '', 'targetCustomersFormatted' => $targetCustomersFormatted ?? '', 'visibleDatesFormatted' => $visibleDatesFormatted ?? '', 'deleteButtonClass' => 'delete-slide-button delete-view-button'])
        </div>
    </div>
@endif