<?php
/**
 * Created by PhpStorm.
 * User: brian
 * Date: 2/25/20
 * Time: 12:42 PM
 */

namespace Hilco\Models;


class Import_SalesOrder extends WebModel
{
    protected $table = 'Import_SalesOrders';


    public function soldToCustomer() {
        return $this->belongsTo(Customer::class, "soldto_customer_id");
    }

    public function billToCustomer() {
        return $this->belongsTo(Customer::class, "billto_customer_id");
    }

    public function shipToAddressWithTrashed() {
        return $this->belongsTo(CustomerShippingAddress::class, "customershippingaddress_id")->withTrashed();
    }

    public function orderParts()
    {
        return $this->hasMany(Import_SalesOrderLine::class, 'importsalesorder_id')
            ->join('Parts', 'Import_SalesOrderLines.part_id', '=', 'Parts.id');
    }

    public function importOrderLines()
    {
        return $this->hasMany(Import_SalesOrderLine::class, 'importsalesorder_id');
    }

    public function importOrderLineSchedules(){
        return $this->hasMany(Import_SalesOrderLineSchedule::class, 'salesorder_id', 'id');
    }

    public function getFriendlyOrderStatusAttribute() {
        switch($this->order_status){
            case 'CLOSED':
                return 'Closed';
            case 'PENDING_WEB':
                return 'Pending Approval';
            case 'DENIED':
                return 'Approval Denied';
            case 'Invoiced':
                return 'Closed';
        }
        return 'Open';
    }

    public function getTotalQuantityAttribute() {
        $qty = 0;
        $partLines = $this->importOrderLines;
        if ($partLines) {
            foreach($partLines as $partLine){
                $qty += $partLine->quantity;
            }
        }

        return $qty;
    }

    public function getTotalShippedAttribute() {
        $qty = 0;
        $schedules = $this
            ->importOrderLineSchedules()
            ->get();

        if ($schedules) {
            $schedules->each(function ($lineSchedule) use (&$qty) {
                $qty += $lineSchedule->qty_shipped;
            });
        }

        return $qty;
    }
}