<?php

namespace Hilco\Models;
use Hilco\SoftDeletes;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;

/**
 * Hilco\Models\CustomerSegment
 *
 * @property mixed $id
 * @property \Hilco\Models\Division $division
 * @property mixed $division_id
 * @property string $cust_no
 * @property mixed $customer_id
 * @property string $cust_name
 * @property string $bill_cust_no
 * @property mixed $billto_customer_id
 * @property string $bill_cust_name
 * @property string $parent_cust_no
 * @property mixed $parent_customer_id
 * @property string $parent_cust_name
 * @property string $cust_type
 * @property mixed $customertypechannel_id
 * @property string $sales_rep
 * @property string $sales_group
 * @property string $sales_mgr
 * @property boolean $active
 * @property string $webcust
 * @property string $def_price_list
 * @property string $def_pmt_terms
 * @property boolean $cust_txbl
 * @property string $last_ord_date
 * @property string $last_chk_date
 * @property float $last_chk_amt
 * @property string $date_created
 * @property string $date_modified
 * @property string $deleted_at
 * @property-read \Illuminate\Database\Eloquent\Collection|\Hilco\Models\Order[] $orders
 * @property-read \Illuminate\Database\Eloquent\Collection|\Hilco\Models\CustomerShippingAddress[] $shipping_addresses
 * @property-read mixed $id_string
 * @property-read Customer $customer
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerSegment whereId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerSegment whereDivision($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerSegment whereDivisionId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerSegment whereCustNo($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerSegment whereCustomerId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerSegment whereCustName($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerSegment whereBillCustNo($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerSegment whereBilltoCustomerId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerSegment whereBillCustName($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerSegment whereParentCustNo($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerSegment whereParentCustomerId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerSegment whereParentCustName($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerSegment whereCustType($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerSegment whereCustomertypechannelId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerSegment whereSalesRep($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerSegment whereSalesGroup($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerSegment whereSalesMgr($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerSegment whereActive($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerSegment whereWebcust($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerSegment whereDefPriceList($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerSegment whereDefPmtTerms($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerSegment whereCustTxbl($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerSegment whereLastOrdDate($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerSegment whereLastChkDate($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerSegment whereLastChkAmt($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerSegment whereDateCreated($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerSegment whereDateModified($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerSegment whereDeletedAt($value)
 * @mixin \Eloquent
 * @property string $sales_rep_2
 * @property string $support_rep
 * @property string $support_rep_2
 * @property integer $credit_limit
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerSegment whereSalesRep2($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerSegment whereSupportRep($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerSegment whereSupportRep2($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerSegment whereCreditLimit($value)
 * @property integer $primarysales_salesrep_id
 * @property integer $secondarysales_salesrep_id
 * @property integer $primarysupport_salesrep_id
 * @property integer $secondarysupport_salesrep_id
 * @property integer $paymentterms_id
 * @property string $date_uploaded
 * @property string $facility_id
 * @property string $default_shipfrom_id
 * @property string $def_ship_from
 * @property string $def_ship_policy
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerSegment wherePrimarysalesSalesrepId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerSegment whereSecondarysalesSalesrepId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerSegment wherePrimarysupportSalesrepId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerSegment whereSecondarysupportSalesrepId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerSegment wherePaymenttermsId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerSegment whereDateUploaded($value)
 * @property-read \Hilco\Models\SalesRep $primarySupportPerson
 */

class CustomerSegment extends Model
{
	protected $table = 'CustomerSegments';
	use SoftDeletes;

	public function customer() {
		return $this->belongsTo(Customer::class, 'customer_id');
	}

	public function billToCustomer() {
	    $relation = $this->belongsTo(Customer::class, 'billto_customer_id', 'id');
        return $relation;
    }

	public function parentCustomer() {
	    return $this->belongsTo(Customer::class, 'parent_customer_id', 'id');
    }

	public function primarySupportPerson() {
		return $this->belongsTo(SalesRep::class, "primarysupport_salesrep_id");
	}

	public function primarySalesRep() {
	    return $this->belongsTo(SalesRep::class, 'primarysales_salesrep_id');
    }

	public function orders()
	{
		return $this->hasMany(Order::class, 'soldto_customersegment_id');
	}

	public function shipping_addresses()
	{
		return $this->hasMany(CustomerShippingAddress::class, 'customersegment_id');
	}

	public function address(){
		return $this->belongsTo(CustomerShippingAddress::class,'customershippingaddress_id');
	}

	public function additionalTaxCustomerSegment() {
	    return $this->hasMany(AdditionalTaxCustomerSegment::class, 'customersegment_id')->where('deleted_at', '0000-00-00 00:00:00');
    }

	public function division()
	{
		return $this->hasOne(Division::class);
	}

	public function facilityDivision() {
        return $this->hasOne(FacilityDivision::class, 'facility_id', 'facility_id');
    }

	public function getBuyingGroupName() {
	    return $this->bill_cust_name;
    }

	public function scopeActive(Builder $query) {
	    return $query->where('active', 1);
    }

    public function getBillsDirectAttribute() {
	    return ($this->billto_customer_id == $this->customer_id);
    }

    public function paymentTerm() {
	    return $this->belongsTo(PaymentTerm::class, 'paymentterms_id');
    }

    public function plant() {
        return $this->belongsTo(Plant::class, 'default_shipfrom_id', 'id');
    }

    public function getIsVegasDefault() {
	    return Plant::LASVEGAS_CODE == $this->def_ship_from ;
    }

    public function assortment() {
        return $this->belongsTo(Assortment::class, 'assortment_id');
    }

    public function getLatestCallAmongAffiliates() {
        return Call::getLatestCallFromListOfCustomers($this->customer->affiliatedCustomers);
    }
}
