<?php

namespace Hilco\Providers;
use App;
use Hilco\Events\UserWasRegistered;
use Hilco\Listeners\EmailNewUserAlert;
use Hilco\Models\WebAsset;
use Hilco\Models\WebPart;
use Hilco\Models\Promo;
use Illuminate\Database\Eloquent\Relations\Relation;
use Illuminate\Support\Facades\Event;
use Illuminate\View\View;
use Illuminate\Support\ServiceProvider;

class HilcoB2BSharedProvider extends ServiceProvider {
    public function register() {
        $this->mergeConfigFrom(__DIR__ . '/../../config/hilco.php', 'hilco');
        $this->mergeConfigFrom(__DIR__ . '/../../config/creditcards.php', 'creditcards');

        App::singleton('rateShop', function() {
            return new \Hilco\RateShop();
        });

        App::singleton('generalPromos', function() {
            return Promo::active()->forAllCart()->with('rules')->get();
        });
    }

    public function boot() {
        $this->loadTranslationsFrom(__DIR__ . '/../../resources/lang', 'hilco');

        $this->publishes([
            __DIR__ . '/../../config/layoutcomponents.php' => config_path('layoutcomponents.php')
        ], 'hilco-shared');

        $this->publishes([
            __DIR__ . '/../../config/hilco.php' => config_path('hilco.php')
        ], 'hilco');

        $this->loadViewsFrom(__DIR__ . '/../../resources/views', 'hilco');

        Relation::morphMap(WebAsset::getMorphMap());

        view()->creator('hilco::components.*', function (View $view) {
            $data = $view->getData();
            if (!array_has($data, 'edit')) $view->with('edit', false);
            if (!array_has($data, 'wrap')) $view->with('wrap', false);
            if (!array_has($data, 'script')) $view->with('script', false);
            if (!array_has($data, 'view')) $view->with('view', false);
        });

        foreach (config('hilco.components', []) as $key => $component) {
            view()->creator($component['view'], function (View $view) use ($component) {
                $viewData = $view->getData();
                $compData = array_dot($component['defaultViewData']);
                foreach ($compData as $kk => $vv) {
                    if (!array_has($viewData, $kk)) array_set($viewData, $kk, $vv);
                }
                $view->with($viewData);
            });
        }
    }
}