<?php

namespace Hilco\Models;

use Illuminate\Database\Eloquent\Model;

class WebCustomerLimit extends WebModel
{
	protected $table = 'WebCustomerLimits';
	protected $fillable = ['customer_id', 'limit_type', 'limit_value'];

    public static $types;

    public function __construct($attributes = [])
    {
        parent::__construct($attributes);

        $this->types = [
            'minimum_order_quantity' => trans('hilco::app.minimum_order_quantity'),
            'maximum_order_quantity' => trans('hilco::app.maximum_order_quantity'),
            'minimum_order_dollar' => trans('hilco::app.minimum_order_dollars'),
            'maximum_order_dollar' => trans('hilco::app.maximum_order_dollars'),
        ];
    }

    public function customer() {
        return $this->belongsTo(Customer::class, 'customer_id', 'id');
    }
}
