<?php

namespace Hilco\Models;
use Illuminate\Database\Eloquent\Model;

/**
 * Hilco\Models\CustomerShippingAddress
 *
 * @property integer $id
 * @property string $division
 * @property integer $division_id
 * @property string $cust_no
 * @property integer $customersegment_id
 * @property string $cust_name
 * @property string $addr_no
 * @property string $addr_type
 * @property string $addr_1
 * @property string $addr_2
 * @property string $addr_3
 * @property string $addr_4
 * @property string $addr_5
 * @property string $city
 * @property string $state
 * @property string $postal_cd
 * @property string $country
 * @property string $def_ship_from
 * @property integer $default_shipfrom_id
 * @property string $def_ship_wh
 * @property string $def_ship_via
 * @property string $def_fob_cd
 * @property integer $default_fob_id
 * @property integer $carrier_id
 * @property string $def_carr_cd
 * @property string $def_carrier
 * @property string $territory_code
 * @property integer $salesterritory_id
 * @property string $date_created
 * @property string $date_modified
 * @property string $date_uploaded
 * @property integer $commit_sequence
 * @property string $deleted_at
 * @property string $def_delivery_method
 * @property integer $deliveryterm_id
 * @property integer $deliverymethod_id
 * @property string $def_delivery_term
 * @property string $attn_of_name
 * @property string $addressid
 * @property string $place_of_unload
 * @property string $back_order
 * @property string $valid_from_date
 * @property string $valid_to_date
 * @property string $partial_delivery
 * @property string $tax_code
 * @property string $status_code
 * @property-read mixed $id_string
 * @property-read CustomerSegment $customerSegment
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerShippingAddress whereId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerShippingAddress whereDivision($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerShippingAddress whereDivisionId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerShippingAddress whereCustNo($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerShippingAddress whereCustomerdivisionId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerShippingAddress whereCustName($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerShippingAddress whereAddrNo($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerShippingAddress whereAddrType($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerShippingAddress whereAddr1($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerShippingAddress whereAddr2($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerShippingAddress whereAddr3($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerShippingAddress whereAddr4($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerShippingAddress whereAddr5($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerShippingAddress whereCity($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerShippingAddress whereState($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerShippingAddress wherePostalCd($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerShippingAddress whereCountry($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerShippingAddress whereDefShipFrom($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerShippingAddress whereDefShipWh($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerShippingAddress whereDefShipVia($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerShippingAddress whereDefFobCd($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerShippingAddress whereDefCarrCd($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerShippingAddress whereDefCarrier($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerShippingAddress whereDateCreated($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerShippingAddress whereDateModified($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerShippingAddress whereDeletedAt($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerShippingAddress whereCarrierId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerShippingAddress whereDefaultShipfromId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerShippingAddress whereDefaultFobId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerShippingAddress whereTerritoryCode($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerShippingAddress whereSalesterritoryId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerShippingAddress whereDateUploaded($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerShippingAddress hasShipToProfile()
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerShippingAddress isActive()
 * @mixin \Eloquent
 */
class CustomerShippingAddress extends Model
{
	protected $table = 'CustomerShippingAddresses';
	public static $usStates = [
		'AL'=>'ALABAMA',
		'AK'=>'ALASKA',
		'AS'=>'AMERICAN SAMOA',
		'AZ'=>'ARIZONA',
		'AR'=>'ARKANSAS',
		'CA'=>'CALIFORNIA',
		'CO'=>'COLORADO',
		'CT'=>'CONNECTICUT',
		'DE'=>'DELAWARE',
		'DC'=>'DISTRICT OF COLUMBIA',
		'FM'=>'FEDERATED STATES OF MICRONESIA',
		'FL'=>'FLORIDA',
		'GA'=>'GEORGIA',
		'GU'=>'GUAM GU',
		'HI'=>'HAWAII',
		'ID'=>'IDAHO',
		'IL'=>'ILLINOIS',
		'IN'=>'INDIANA',
		'IA'=>'IOWA',
		'KS'=>'KANSAS',
		'KY'=>'KENTUCKY',
		'LA'=>'LOUISIANA',
		'ME'=>'MAINE',
		'MH'=>'MARSHALL ISLANDS',
		'MD'=>'MARYLAND',
		'MA'=>'MASSACHUSETTS',
		'MI'=>'MICHIGAN',
		'MN'=>'MINNESOTA',
		'MS'=>'MISSISSIPPI',
		'MO'=>'MISSOURI',
		'MT'=>'MONTANA',
		'NE'=>'NEBRASKA',
		'NV'=>'NEVADA',
		'NH'=>'NEW HAMPSHIRE',
		'NJ'=>'NEW JERSEY',
		'NM'=>'NEW MEXICO',
		'NY'=>'NEW YORK',
		'NC'=>'NORTH CAROLINA',
		'ND'=>'NORTH DAKOTA',
		'MP'=>'NORTHERN MARIANA ISLANDS',
		'OH'=>'OHIO',
		'OK'=>'OKLAHOMA',
		'OR'=>'OREGON',
		'PW'=>'PALAU',
		'PA'=>'PENNSYLVANIA',
		'PR'=>'PUERTO RICO',
		'RI'=>'RHODE ISLAND',
		'SC'=>'SOUTH CAROLINA',
		'SD'=>'SOUTH DAKOTA',
		'TN'=>'TENNESSEE',
		'TX'=>'TEXAS',
		'UT'=>'UTAH',
		'VT'=>'VERMONT',
		'VI'=>'VIRGIN ISLANDS',
		'VA'=>'VIRGINIA',
		'WA'=>'WASHINGTON',
		'WV'=>'WEST VIRGINIA',
		'WI'=>'WISCONSIN',
		'WY'=>'WYOMING',
		'AE'=>'ARMED FORCES AFRICA \ CANADA \ EUROPE \ MIDDLE EAST',
		'AA'=>'ARMED FORCES AMERICA (EXCEPT CANADA)',
		'AP'=>'ARMED FORCES PACIFIC'
	];
	public static $countries = [
		'AF'=>'AFGHANISTAN',
		'AL'=>'ALBANIA',
		'DZ'=>'ALGERIA',
		'AS'=>'AMERICAN SAMOA',
		'AD'=>'ANDORRA',
		'AO'=>'ANGOLA',
		'AI'=>'ANGUILLA',
		'AQ'=>'ANTARCTICA',
		'AG'=>'ANTIGUA AND BARBUDA',
		'AR'=>'ARGENTINA',
		'AM'=>'ARMENIA',
		'AW'=>'ARUBA',
		'AU'=>'AUSTRALIA',
		'AT'=>'AUSTRIA',
		'AZ'=>'AZERBAIJAN',
		'BS'=>'BAHAMAS',
		'BH'=>'BAHRAIN',
		'BD'=>'BANGLADESH',
		'BB'=>'BARBADOS',
		'BY'=>'BELARUS',
		'BE'=>'BELGIUM',
		'BZ'=>'BELIZE',
		'BJ'=>'BENIN',
		'BM'=>'BERMUDA',
		'BT'=>'BHUTAN',
		'BO'=>'BOLIVIA',
		'BA'=>'BOSNIA AND HERZEGOVINA',
		'BW'=>'BOTSWANA',
		'BV'=>'BOUVET ISLAND',
		'BR'=>'BRAZIL',
		'IO'=>'BRITISH INDIAN OCEAN TERRITORY',
		'BN'=>'BRUNEI DARUSSALAM',
		'BG'=>'BULGARIA',
		'BF'=>'BURKINA FASO',
		'BI'=>'BURUNDI',
		'KH'=>'CAMBODIA',
		'CM'=>'CAMEROON',
		'CA'=>'CANADA',
		'CV'=>'CAPE VERDE',
		'KY'=>'CAYMAN ISLANDS',
		'CF'=>'CENTRAL AFRICAN REPUBLIC',
		'TD'=>'CHAD',
		'CL'=>'CHILE',
		'CN'=>'CHINA',
		'CX'=>'CHRISTMAS ISLAND',
		'CC'=>'COCOS (KEELING) ISLANDS',
		'CO'=>'COLOMBIA',
		'KM'=>'COMOROS',
		'CG'=>'CONGO',
		'CD'=>'CONGO, THE DEMOCRATIC REPUBLIC OF THE',
		'CK'=>'COOK ISLANDS',
		'CR'=>'COSTA RICA',
		'CI'=>'COTE D IVOIRE',
		'HR'=>'CROATIA',
		'CU'=>'CUBA',
		'CY'=>'CYPRUS',
		'CZ'=>'CZECH REPUBLIC',
		'DK'=>'DENMARK',
		'DJ'=>'DJIBOUTI',
		'DM'=>'DOMINICA',
		'DO'=>'DOMINICAN REPUBLIC',
		'TP'=>'EAST TIMOR',
		'EC'=>'ECUADOR',
		'EG'=>'EGYPT',
		'SV'=>'EL SALVADOR',
		'GQ'=>'EQUATORIAL GUINEA',
		'ER'=>'ERITREA',
		'EE'=>'ESTONIA',
		'ET'=>'ETHIOPIA',
		'FK'=>'FALKLAND ISLANDS (MALVINAS)',
		'FO'=>'FAROE ISLANDS',
		'FJ'=>'FIJI',
		'FI'=>'FINLAND',
		'FR'=>'FRANCE',
		'GF'=>'FRENCH GUIANA',
		'PF'=>'FRENCH POLYNESIA',
		'TF'=>'FRENCH SOUTHERN TERRITORIES',
		'GA'=>'GABON',
		'GM'=>'GAMBIA',
		'GE'=>'GEORGIA',
		'DE'=>'GERMANY',
		'GH'=>'GHANA',
		'GI'=>'GIBRALTAR',
		'GR'=>'GREECE',
		'GL'=>'GREENLAND',
		'GD'=>'GRENADA',
		'GP'=>'GUADELOUPE',
		'GU'=>'GUAM',
		'GT'=>'GUATEMALA',
		'GN'=>'GUINEA',
		'GW'=>'GUINEA-BISSAU',
		'GY'=>'GUYANA',
		'HT'=>'HAITI',
		'HM'=>'HEARD ISLAND AND MCDONALD ISLANDS',
		'VA'=>'HOLY SEE (VATICAN CITY STATE)',
		'HN'=>'HONDURAS',
		'HK'=>'HONG KONG',
		'HU'=>'HUNGARY',
		'IS'=>'ICELAND',
		'IN'=>'INDIA',
		'ID'=>'INDONESIA',
		'IR'=>'IRAN, ISLAMIC REPUBLIC OF',
		'IQ'=>'IRAQ',
		'IE'=>'IRELAND',
		'IL'=>'ISRAEL',
		'IT'=>'ITALY',
		'JM'=>'JAMAICA',
		'JP'=>'JAPAN',
		'JO'=>'JORDAN',
		'KZ'=>'KAZAKSTAN',
		'KE'=>'KENYA',
		'KI'=>'KIRIBATI',
		'KP'=>'KOREA DEMOCRATIC PEOPLES REPUBLIC OF',
		'KR'=>'KOREA REPUBLIC OF',
		'KW'=>'KUWAIT',
		'KG'=>'KYRGYZSTAN',
		'LA'=>'LAO PEOPLES DEMOCRATIC REPUBLIC',
		'LV'=>'LATVIA',
		'LB'=>'LEBANON',
		'LS'=>'LESOTHO',
		'LR'=>'LIBERIA',
		'LY'=>'LIBYAN ARAB JAMAHIRIYA',
		'LI'=>'LIECHTENSTEIN',
		'LT'=>'LITHUANIA',
		'LU'=>'LUXEMBOURG',
		'MO'=>'MACAU',
		'MK'=>'MACEDONIA, THE FORMER YUGOSLAV REPUBLIC OF',
		'MG'=>'MADAGASCAR',
		'MW'=>'MALAWI',
		'MY'=>'MALAYSIA',
		'MV'=>'MALDIVES',
		'ML'=>'MALI',
		'MT'=>'MALTA',
		'MH'=>'MARSHALL ISLANDS',
		'MQ'=>'MARTINIQUE',
		'MR'=>'MAURITANIA',
		'MU'=>'MAURITIUS',
		'YT'=>'MAYOTTE',
		'MX'=>'MEXICO',
		'FM'=>'MICRONESIA, FEDERATED STATES OF',
		'MD'=>'MOLDOVA, REPUBLIC OF',
		'MC'=>'MONACO',
		'MN'=>'MONGOLIA',
		'MS'=>'MONTSERRAT',
		'MA'=>'MOROCCO',
		'MZ'=>'MOZAMBIQUE',
		'MM'=>'MYANMAR',
		'NA'=>'NAMIBIA',
		'NR'=>'NAURU',
		'NP'=>'NEPAL',
		'NL'=>'NETHERLANDS',
		'AN'=>'NETHERLANDS ANTILLES',
		'NC'=>'NEW CALEDONIA',
		'NZ'=>'NEW ZEALAND',
		'NI'=>'NICARAGUA',
		'NE'=>'NIGER',
		'NG'=>'NIGERIA',
		'NU'=>'NIUE',
		'NF'=>'NORFOLK ISLAND',
		'MP'=>'NORTHERN MARIANA ISLANDS',
		'NO'=>'NORWAY',
		'OM'=>'OMAN',
		'PK'=>'PAKISTAN',
		'PW'=>'PALAU',
		'PS'=>'PALESTINIAN TERRITORY, OCCUPIED',
		'PA'=>'PANAMA',
		'PG'=>'PAPUA NEW GUINEA',
		'PY'=>'PARAGUAY',
		'PE'=>'PERU',
		'PH'=>'PHILIPPINES',
		'PN'=>'PITCAIRN',
		'PL'=>'POLAND',
		'PT'=>'PORTUGAL',
		'PR'=>'PUERTO RICO',
		'QA'=>'QATAR',
		'RE'=>'REUNION',
		'RO'=>'ROMANIA',
		'RU'=>'RUSSIAN FEDERATION',
		'RW'=>'RWANDA',
		'SH'=>'SAINT HELENA',
		'KN'=>'SAINT KITTS AND NEVIS',
		'LC'=>'SAINT LUCIA',
		'PM'=>'SAINT PIERRE AND MIQUELON',
		'VC'=>'SAINT VINCENT AND THE GRENADINES',
		'WS'=>'SAMOA',
		'SM'=>'SAN MARINO',
		'ST'=>'SAO TOME AND PRINCIPE',
		'SA'=>'SAUDI ARABIA',
		'SN'=>'SENEGAL',
		'SC'=>'SEYCHELLES',
		'SL'=>'SIERRA LEONE',
		'SG'=>'SINGAPORE',
		'SK'=>'SLOVAKIA',
		'SI'=>'SLOVENIA',
		'SB'=>'SOLOMON ISLANDS',
		'SO'=>'SOMALIA',
		'ZA'=>'SOUTH AFRICA',
		'GS'=>'SOUTH GEORGIA AND THE SOUTH SANDWICH ISLANDS',
		'ES'=>'SPAIN',
		'LK'=>'SRI LANKA',
		'SD'=>'SUDAN',
		'SR'=>'SURINAME',
		'SJ'=>'SVALBARD AND JAN MAYEN',
		'SZ'=>'SWAZILAND',
		'SE'=>'SWEDEN',
		'CH'=>'SWITZERLAND',
		'SY'=>'SYRIAN ARAB REPUBLIC',
		'TW'=>'TAIWAN, PROVINCE OF CHINA',
		'TJ'=>'TAJIKISTAN',
		'TZ'=>'TANZANIA, UNITED REPUBLIC OF',
		'TH'=>'THAILAND',
		'TG'=>'TOGO',
		'TK'=>'TOKELAU',
		'TO'=>'TONGA',
		'TT'=>'TRINIDAD AND TOBAGO',
		'TN'=>'TUNISIA',
		'TR'=>'TURKEY',
		'TM'=>'TURKMENISTAN',
		'TC'=>'TURKS AND CAICOS ISLANDS',
		'TV'=>'TUVALU',
		'UG'=>'UGANDA',
		'UA'=>'UKRAINE',
		'AE'=>'UNITED ARAB EMIRATES',
		'GB'=>'UNITED KINGDOM',
		'US'=>'UNITED STATES',
		'UM'=>'UNITED STATES MINOR OUTLYING ISLANDS',
		'UY'=>'URUGUAY',
		'UZ'=>'UZBEKISTAN',
		'VU'=>'VANUATU',
		'VE'=>'VENEZUELA',
		'VN'=>'VIET NAM',
		'VG'=>'VIRGIN ISLANDS, BRITISH',
		'VI'=>'VIRGIN ISLANDS, U.S.',
		'WF'=>'WALLIS AND FUTUNA',
		'EH'=>'WESTERN SAHARA',
		'YE'=>'YEMEN',
		'YU'=>'YUGOSLAVIA',
		'ZM'=>'ZAMBIA',
		'ZW'=>'ZIMBABWE',
	];

	public function customerSegment()
	{
		return $this->belongsTo(CustomerSegment::class, 'customersegment_id');
	}

	public function plant() {
	    return $this->belongsTo(Plant::class, 'default_shipfrom_id', 'id');
    }

	public function warehouse($plantID = null) {
		return Warehouse::where('plant_id', '=', $plantID !== null ? $plantID : $this->default_shipfrom_id)->where('warehouse', '=', $this->def_ship_wh)->first();
	}
	
	public function scopeDivision($query, $division) {
		return $query->whereDivision($division);
	}

	public function defaultCarrier() {
	    return $this->hasOne(Carrier::class, 'carrier_code', 'def_carr_cd');
    }

    public function scopeHasShipToProfile($query) {
	    return $query
            ->whereNotNull('id')
            ->whereNotNull('deliverymethod_id')
            ->whereNotNull('deliveryterm_id')
        ;
    }

    public function scopeIsActive ($query) {
	    return $query->whereRaw(
	        '(
	            valid_from_date IS NULL OR 
	            valid_from_date = 0 OR 
	            valid_from_date <= DATE(NOW())
            ) 
	        AND 
	        (
	            valid_to_date IS NULL OR 
	            valid_to_date = 0 OR 
	            valid_to_date >= DATE(NOW())
	        )'
        );
    }

    use \Hilco\SoftDeletes;
}
