<?php

namespace Hilco\Models;

use Illuminate\Database\Eloquent\Model;

class SearchBucketRange extends Model
{
	use \Hilco\SoftDeletes;

	const CREATED_AT = 'date_created';
	const UPDATED_AT = 'date_modified';

	protected $table = 'SearchBucketRanges';
	protected $fillable = ['bucket_name', 'webattribute_id', 'range_min', 'range_max'];

    public function webAttribute() {
        return $this->belongsTo(WebAttribute::class, 'webattribute_id', 'id');
    }

}
