<?php

namespace Hilco\Models;

/**
 * Hilco\Models\WebLandingPage
 *
 * @property integer $id
 * @property string $name
 * @property string $date_created
 * @property string $date_modified
 * @property string $deleted_at
 * @property-read \Illuminate\Database\Eloquent\Collection|\Hilco\Models\WebContext_WebLandingPage[] $contexts
 * @property-read mixed $context
 * @property-read mixed $default_context
 * @property-read mixed $web_layout
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\WebLandingPage whereId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\WebLandingPage whereName($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\WebLandingPage whereDateCreated($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\WebLandingPage whereDateModified($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\WebLandingPage whereDeletedAt($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\WebLandingPage named($name)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\HierarchyModel joinContext($contextId = false)
 * @mixin \Eloquent
 * @property string $slug
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\WebLandingPage whereSlug($value)
 */
class WebLandingPage extends HierarchyModel implements HasLandingPageInterface {

	protected $table = "WebLandingPages";
    protected $fillable = ['detail'];
	protected $context_attributes = [];
	protected $context_table = 'WebContext_WebLandingPage';
	protected $context_foreign_key = 'weblandingpage_id';

    public function featuredChildren() {
        return collect();
    }

    public function getAssetPrefix() {
        return "webLandingPage/{$this->id}";
    }

    public function slugUrl() {
        return route('landingpage.slug', [$this->slug]);
    }

    public function thumbnailUrl() {
        return assetImage($this->getAssetPrefix() . '/featured');
    }

	use HasSlug, HasLandingPage;

}
