<?php

namespace Hilco\Models;

use Illuminate\Auth\Authenticatable;
use Illuminate\Auth\Passwords\CanResetPassword;
use Illuminate\Contracts\Auth\Access\Authorizable as AuthorizableContract;
use Illuminate\Contracts\Auth\Authenticatable as AuthenticatableContract;
use Illuminate\Contracts\Auth\CanResetPassword as CanResetPasswordContract;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Foundation\Auth\Access\Authorizable;
use Venturecraft\Revisionable\RevisionableTrait;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Hilco\Models\WebContactUsMessages
 *
 * @property integer $id
 * @property string $customer_number
 * @property string $name
 * @property string $street_and_number
 * @property string $postal_code
 * @property string $city
 * @property string $country
 * @property string $phone
 * @property string $email
 * @property string $message
 *
 * @property string $date_created
 * @property string $date_modified
 * @property string $date_uploaded
 * @property string $deleted_at
 * @method static WebContactUsMessages firstOrNew($attributes)
 * @mixin \Eloquent
 */
class WebContactUsMessage extends WebModel {

	protected $table = "WebContactUsMessages";

	protected $fillable = [
        'webUser_id',
        'customer_number',
        'customer_name',
        'name',
        'street_and_number',
        'additional_address',
        'postal_code',
        'city',
        'country',
        'phone',
        'fax',
        'email',
        'vat',
        'message'
    ];

}
