<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 1/19/2017
 * Time: 10:35 AM
 */

namespace Hilco\Listeners;


use Hilco\Events\UserWasRegistered;
use Illuminate\Contracts\Mail\Mailer;
use Illuminate\Support\Facades\Mail;

/**
 * Sends an email to customer service to alert that a new user was created.
 *
 * Class EmailNewUserAlert
 * @package Hilco\Listeners
 */
class EmailNewUserAlert {

    public function construct() {

    }

    public function handle(UserWasRegistered $event) {
        if ($event->selfCreated) {
            Mail::send('hilco::emails.newUserAlert', ['webUser' => $event->webUser], function ($mail) use ($event) {
                return $mail
                    ->to(config('hilco.email.newUserAlert.destination'))
                    ->bcc('support@visionwaresystems.com')
                    ->subject(trans('hilco::email.newUserAlertSubject', ['customerNumber' => $event->webUser->customer->cust_no]))
                ;
            });
        }
    }
}