<?php

use Carbon\Carbon;
use Hilco\Models\WebAsset;
use Hilco\Models\WebCategory;
use Hilco\Models\WebCollection;
use Hilco\Models\WebFamily;
use Hilco\Models\WebGroup;
use Hilco\Models\WebLandingPage;
use Hilco\Models\WebPart;


if (! function_exists('createAssetAccessToken')) {
    function createAssetAccessToken() {
        $salt = config('hilco.assets.tokenSalt');
        $timestamp = Carbon::now()->getTimestamp();
        return ['timestamp' => $timestamp, 'token' => md5($salt . $timestamp . $salt . $timestamp . $salt)];
    }
}

if (! function_exists('validateAssetAccessToken')) {
    function validateAssetAccessToken($token, $timestamp) {
        $salt = config('hilco.assets.tokenSalt');
        $now = Carbon::now();
        $then = Carbon::createFromTimestamp($timestamp);
        if ($now->subMinutes(5) > $then) return false;
        return $token == md5($salt . $timestamp . $salt . $timestamp . $salt);
    }
}

if (! function_exists('webAssetUrl')) {
    function webAssetUrl($options) {
        return WebAsset::urlHelper($options);
    }
}

if (! function_exists('webLinkUrl')) {
    function webLinkUrl($options) {
        switch (array_get($options, 'type', 'url')) {
            case 'url':
                return array_get($options, 'target', '');
            case 'webLandingPage':
                return route('landingpage.slug', [array_get($options, 'target')]);
            case 'webAsset':
                return WebAsset::urlHelper(['id' => $options['target'], 'download' => true, 'token' => true]);
        }
    }
}

if (! function_exists('webLinkTitle')) {
    function webLinkTitle($options) {
        $target = array_get($options, 'target', '');
        switch (array_get($options, 'type', 'url')) {
            case 'url':
                return $target;
            case 'webLandingPage':
                $webLandingPage = WebLandingPage::whereSlug($target)->first();
                return $webLandingPage ? $webLandingPage->name : '';
            case 'webAsset':
                $webAsset = WebAsset::find($target);
                return $webAsset ? $webAsset->name : '';
        }
    }
}

if (!function_exists('productLink')) {
    function productLink($type, $id) {
        switch ($type) {
            case 'webFamily':
            case 'Family':
                return '/f/' . WebFamily::find($id)->slug;
            case 'webCollection':
            case 'Collection':
                return '/l/' . WebCollection::find($id)->slug;
            case 'webCategory':
            case 'Category':
                return '/c/' . WebCategory::find($id)->slug;
            case 'webGroup':
            case 'Group':
                return '/g/' . WebGroup::find($id)->slug;
        }
        return false;
    }
}

if (!function_exists('productModel')) {
    function productModel($type, $id) {
        switch ($type) {
            case 'webFamily':
            case 'Family':
                return WebFamily::with('assets')->find($id);
            case 'webCollection':
            case 'Collection':
                return WebCollection::with('assets')->find($id);
            case 'webCategory':
            case 'Category':
                return WebCategory::with('assets')->find($id);
            case 'webGroup':
            case 'Group':
                return WebGroup::with('assets')->find($id);
        }
        return null;
    }
}

if (!function_exists('b2bLink')) {
    function b2bLink($model) {
        $url = config('hilco.b2b.url', false);
        if (!$url) return false;
        switch (get_class($model)) {
            case WebPart::class:
                return $url . '/f/' . $model->webFamily->slug;
            case WebFamily::class:
                return $url . '/f/' . $model->slug;
            case WebCollection::class:
                return $url . '/l/' . $model->slug;
            case WebCategory::class:
                return $url . '/c/' . $model->slug;
            case WebGroup::class:
                return $url . '/g/' . $model->slug;
            case WebLandingPage::class:
                return $url . '/lp/' . $model->slug;
        }
        return false;
    }
}

if (!function_exists('canUser')) {
    function canUser($permission) {
        $user = Auth::user();
        if (is_null($user)) return false;
        return $user->can($permission);
    }
}

if (!function_exists('rewards')) {
    function rewards() {
        return app('rewards');
    }
}

if (!function_exists('transDefault')) {
    function transDefault($id = null, $default = null, $parameters = [], $domain = 'messages', $locale = null) {
        $value = trans($id, $parameters, $domain, $locale);
        return ($value == $id) ? $default : $value;
    }
}

if (!function_exists('generateUUID')) {
    function generateUUID() {
        return DB::select(DB::raw('SELECT UuidToBin(uuid()) as uuid;'))[0]->uuid;
    }
}

if (!function_exists('b2b')) {
    /**
     * @return \Hilco\B2BHelper
     */
    function b2b() {
        return app('b2b');
    }
}

if (!function_exists('m3')) {
    /**
     * @return \Hilco\M3Helper
     */
    function m3() {
        return app('m3');
    }
}

if (!function_exists('array_increment')) {
    function array_increment(&$array, $key, $incrementBy = 1) {
        return array_set($array, $key, array_get($array, $key, 0) + $incrementBy);
    }
}

if (!function_exists('normalizeProductType')) {
    function normalizeProductType($type) {
        switch ($type) {
            case 'Group':
            case 'webGroup':
                return 'webGroup';
            case 'Category':
            case 'webCategory':
                return 'webCategory';
            case 'Collection':
            case 'webCollection':
                return 'webCollection';
            case 'Family':
            case 'webFamily':
                return 'webFamily';
            case 'Part':
            case 'webPart':
                return 'webPart';
        }

        return $type;
    }
}

if (!function_exists('croakies')) {
    /**
     * @return \Hilco\CroakiesHelper
     */
    function croakies() {
        return app('croakies');
    }
}

if (!function_exists('fileSafeName')) {
    function fileSafeName($str) {
        return str_replace(['"','\\',' ',':','?','<','>','&','|','/','.'], '_', $str);
    }
}