<?php
/**
 * Created by PhpStorm.
 * User: brian
 * Date: 2/25/20
 * Time: 12:42 PM
 */

namespace Hilco\Models;


class Import_SalesOrder extends WebModel
{
    protected $table = 'Import_SalesOrders';


    public function soldToCustomer() {
        return $this->belongsTo(Customer::class, "soldto_customer_id");
    }

    public function billToCustomer() {
        return $this->belongsTo(Customer::class, "billto_customer_id");
    }

    public function shipToAddressWithTrashed() {
        return $this->belongsTo(CustomerShippingAddress::class, "customershippingaddress_id")->withTrashed();
    }

    public function orderParts()
    {
        return $this->hasMany(Import_SalesOrderLine::class, 'salesorder_id')
            ->join('Parts', 'Import_SalesOrderLines.part_id', '=', 'Parts.id');
    }

    public function shipmentUnitItems() {
        return $this->hasMany(ShipmentUnitItem::class, 'importsalesorder_id', 'id');
    }

    public static function getIneligibleStatuses() {
        return ['Rejected', 'Canceled', 'CANCELLED', 'DISCARDED', 'PENDING', 'EXPORTING', 'DENIED', 'SENT_TO_POINTMAN', 'Unapproved', 'Deleted', 'Hold', 'PENDING_APPROVAL', 'PENDING_WEB', 'ADDRESS_PENDING'];
    }
}