<?php
/**
 * Created by PhpStorm.
 * User: brian
 * Date: 2/25/20
 * Time: 12:46 PM
 */

namespace Hilco\Models;


use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

/**
 * @property-read integer $id
 * @property-read string $line_status
 * @property-read integer $part_id
 * @property-read integer $quantity
 * @property-read float $unit_price
 * @property-read float $ext_amount
 * @property-read string $customer_reference
 * @property-read integer $qty_short
 * @property-read integer $qty_shipped
 * @property-read Part $part
 * @property-read Collection|Import_SalesOrderDiscLine[] $importSalesOrderDiscLines
 */
class Import_SalesOrderLine extends WebModel {
    protected $table = 'Import_SalesOrderLines';

    /**
     * @return BelongsTo
     */
    public function part(): BelongsTo {
        return $this->belongsTo(Part::class, 'part_id');
    }

    /**
     * @return HasMany
     */
    public function importSalesOrderDiscLines(): HasMany {
        return $this->hasMany(Import_SalesOrderDiscLine::class, "importsalesorderline_id", "id");
    }

    public function getLineStatus() {
        return $this->line_status;
    }

    public function getQuantity() {
        return $this->quantity;
    }

    public function getUnitPrice() {
        return $this->unit_price;
    }

    public function getLinePrice() {
        return $this->ext_amount;
    }

    public function getTrayInfo() {
        return $this->customer_reference;
    }

    public function getOpenQty() {
        return $this->qty_short;
    }

    public function getShippedQty() {
        return $this->qty_shipped;
    }

    /**
     * Note: Import_SalesOrderDiscLines.discount_amount is the extension discount amount, not the unit discount amount
     * @return int|mixed
     */
    public function getTotalDiscountAmount() {
        return $this->importSalesOrderDiscLines()->sum("discount_amount");
    }

    /**
     * Note: getLinePrice() returns Import_SalesOrderLines.ext_amount, which is the extension price not the unit price
     * @return float|int|mixed
     */
    public function getRealLinePrice() {
        return $this->getLinePrice() - $this->getTotalDiscountAmount();
    }
}