<?php

namespace Hilco\Models;
use Illuminate\Database\Eloquent\Model;

class WebCustomerSalesSummary extends Model {
    protected $table = "WebCustomerSalesSummary";
    protected $fillable = ['customer_id', 'order_date'];
    public $timestamps = false;

    public function values() {
        return $this->hasMany(WebCustomerSalesSummaryValue::class, 'webcustomersalessummary_id', 'id');
    }

    public function customer() {
        return $this->belongsTo(Customer::class, 'customer_id', 'id');
    }
}
