<?php

namespace Hilco\Models;
use Carbon\Carbon;
use Hilco\SoftDeletes;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class CustomerRewardsRegistration extends UuidModel {
	protected $table = 'CustomerRewardsRegistration';
	protected $fillable = [
	    'customer_id',
	    'customercategory_id',
        'mdOnSite',
        'odOnSite',
        'leasedDoctorOnSite',
        'opticianOnSite',
        'dispensesEyewear',
        'dispensesFashionEyewear',
        'dispensesChildrenEyewear',
        'dispensesSportSafetyEyewear',
        'dispensesOccupationalSafetyEyewear',
        'ownMultipleLocations',
    ];

	public function customer() {
	    return $this->belongsTo(Customer::class, 'customer_id', 'id');
    }

    public function customerCategory() {
	    return $this->belongsTo(CustomerCategory::class, 'customercategory_id', 'id');
    }

    use SoftDeletes;
}
