<?php

namespace Hilco\Models;

/**
 * Hilco\Models\EPaper
 *
 * @property integer $id
 * @property string $slug
 * @property string $description
 * @property boolean $require_login
 * @property string $date_created
 * @property string $date_modified
 * @property string $deleted_at
 */
class EPaper extends WebModel {
	protected $table = "EPapers";
    protected $fillable = ['slug', 'description', 'require_login'];
    protected $casts = ['require_login' => 'boolean'];

	use HasSlug;

    /**
     * @return bool
     */
    public function requiresLogin(): bool {
        return $this->require_login;
    }
}