<?php

namespace Hilco\Models;
use DB;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Collection;

class RateShopGroup extends Model {
	protected $table = "RateShopGroups";

	const CA_GROUP_CODE = 2;
	const US_GROUP_CODE = 3;

	public function scopeGroupCode($query, $groupCode) {
	    return $query->where('group_code', '=', $groupCode);
    }

    public function carrier() {
	    return $this->belongsTo(Carrier::class, 'hilco_carrier_code', 'carrier_code');
    }

    public static function calculateGroupCode ($countryCode) {
	    switch ($countryCode) {
            case "CA":
                return RateShopGroup::CA_GROUP_CODE;
            case "US":
            default:
                return RateShopGroup::US_GROUP_CODE;
        }
    }

    public function scopeMethodTermsByGroup($query, $groupCode, $defaultMethod, $defaultTerm, $hideAir) {
	    $query
            ->selectRaw('CONCAT(RateShopGroups.delivery_method, "-", RateShopGroups.delivery_term) AS method_term')
            ->join('RateShopAPIDetails', function ($join) {
                return
                    $join
                        ->on('RateShopAPIDetails.delivery_method', '=', 'RateShopGroups.delivery_method')
                        ->on('RateShopAPIDetails.delivery_term', '=', 'RateShopGroups.delivery_term')
                    ;
            })
            ->where('RateShopGroups.deleted_at', '=', '0000-00-00 00:00:00')
            ->where('RateShopAPIDetails.deleted_at', '=', '0000-00-00 00:00:00')
            ->where(function ($orClause) use ($groupCode, $defaultMethod, $defaultTerm) {
                return
                    $orClause
                        ->where('group_code', $groupCode)
                        ->orWhere(function ($andClause) use ($defaultMethod, $defaultTerm) {
                            return
                                $andClause
                                    ->where('RateShopGroups.delivery_method', $defaultMethod)
                                    ->where('RateShopGroups.delivery_term', $defaultTerm)
                            ;
                        })
                ;
            })
        ;


        if ($defaultMethod == 'U03') {
            $query->where('RateShopGroups.delivery_method', '!=', 'U39');
        } else if ($defaultMethod == 'U39') {
            $query->where('RateShopGroups.delivery_method', '!=', 'U03');
        }

        if ($hideAir) {
            $query->where('RateShopAPIDetails.is_air', 0);
        }

        return $query;
    }
}
