<?php

namespace Hilco\Models;

use Illuminate\Database\Eloquent\Model;

class Customer_Solr extends Model
{
    protected $table = 'Customer_Solr';
    protected $fillable = ['customer_id', 'hash', 'visible', 'lastAction'];

    const UPDATED_AT = 'date_modified';
    const CREATED_AT = 'date_created';

    use \Hilco\SoftDeletes;

    public function item() {
        return $this->belongsTo(Customer::class, 'customer_id', 'id');
    }

    public function scopeByDeletedRecords($query) {
        return
            $query
                ->whereRaw("NOT EXISTS (SELECT 1 FROM Customers  WHERE Customers.id = customer_id AND Customers.deleted_at = '0000-00-00 00:00:00')")
                ->whereRaw("(Customer_Solr.lastAction IN ('Added', 'Updated') OR Customer_Solr.visible != 0)")
            ;
    }
}