<?php
/**
 * Created by PhpStorm.
 * User: brian
 * Date: 1/30/20
 * Time: 2:23 PM
 */

namespace Hilco\Models;

use Eloquent;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Query\Builder;

/**
 * Hilco\Models\SalesOrderSource
 *
 * @property integer $id
 * @property string $order_source_code
 * @property string $order_source_description
 * @property string $date_created
 * @property string $date_modified
 * @property string $date_uploaded
 * @property string $deleted_at
 * @method static Builder|SalesOrderSource whereId($value)
 * @method static Builder|SalesOrderSource whereOrderSourceCode($value)
 * @method static Builder|SalesOrderSource whereOrderSourceDescription($value)
 * @method static Builder|SalesOrderSource whereDateCreated($value)
 * @method static Builder|SalesOrderSource whereDateModified($value)
 * @method static Builder|SalesOrderSource whereDateUploaded($value)
 * @method static Builder|SalesOrderSource whereDeletedAt($value)
 * @mixin Eloquent
 */
class SalesOrderSource extends WebModel {
    protected $table = "SalesOrderSources";

    const WEB_SOURCE = "WEB";

    /**
     * @return SalesOrderSource|null
     */
    public static function getWebSource(): ?SalesOrderSource {
        return SalesOrderSource::where('order_source_code', self::WEB_SOURCE)->first();
    }
}
