<?php

namespace Hilco\Models;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;


/**
 * Hilco\Models\PromoCode
 *
 */
class PromoCode extends Model
{
	protected $table = 'PromoCodes';
	protected $fillable = ['promo_code'];

	public function users() {
		return $this->belongsToMany(WebPart::class, 'PromoCodes_WebUsers', 'promocode_id', 'user_id');
	}

	public function scopeByCode($query, $code){
		return $query->where('promo_code',$code);
	}

	public static function createIfNotExists($code){
		$codeInst = self::byCode($code)->first();
		if(!isset($codeInst)){
			$codeInst = self::create(['promo_code'=>$code]);
		}
		return $codeInst;
	}
}
